/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
define(["exports","./defined-2a4f2d00","./Check-e5651467","./freezeObject-a51e076f","./defaultValue-29c9b1af","./Math-7782f09e","./defineProperties-c817531e"],function(e,A,t,n,c,V,a){"use strict";function b(e,t,n){this.x=c.defaultValue(e,0),this.y=c.defaultValue(t,0),this.z=c.defaultValue(n,0)}b.fromSpherical=function(e,t){A.defined(t)||(t=new b);var n=e.clock,a=e.cone,i=c.defaultValue(e.magnitude,1),r=i*Math.sin(a);return t.x=r*Math.cos(n),t.y=r*Math.sin(n),t.z=i*Math.cos(a),t},b.fromElements=function(e,t,n,a){return A.defined(a)?(a.x=e,a.y=t,a.z=n,a):new b(e,t,n)},b.fromCartesian4=b.clone=function(e,t){if(A.defined(e))return A.defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new b(e.x,e.y,e.z)},b.packedLength=3,b.pack=function(e,t,n){return n=c.defaultValue(n,0),t[n++]=e.x,t[n++]=e.y,t[n]=e.z,t},b.unpack=function(e,t,n){return t=c.defaultValue(t,0),A.defined(n)||(n=new b),n.x=e[t++],n.y=e[t++],n.z=e[t],n},b.packArray=function(e,t){var n=e.length;A.defined(t)?t.length=3*n:t=new Array(3*n);for(var a=0;a<n;++a)b.pack(e[a],t,3*a);return t},b.unpackArray=function(e,t){var n=e.length;A.defined(t)?t.length=n/3:t=new Array(n/3);for(var a=0;a<n;a+=3){var i=a/3;t[i]=b.unpack(e,a,t[i])}return t},b.fromArray=b.unpack,b.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},b.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},b.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},b.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},b.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},b.magnitude=function(e){return Math.sqrt(b.magnitudeSquared(e))};var i=new b;b.distance=function(e,t){return b.subtract(e,t,i),b.magnitude(i)},b.distanceSquared=function(e,t){return b.subtract(e,t,i),b.magnitudeSquared(i)},b.normalize=function(e,t){var n=b.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},b.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},b.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},b.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n},b.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},b.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},b.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},b.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},b.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},b.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var r=new b;b.lerp=function(e,t,n,a){return b.multiplyByScalar(t,n,r),a=b.multiplyByScalar(e,1-n,a),b.add(r,a,a)};var u=new b,o=new b;b.angleBetween=function(e,t){b.normalize(e,u),b.normalize(t,o);var n=b.dot(u,o),a=b.magnitude(b.cross(u,o,u));return Math.atan2(a,n)};var d=new b;b.mostOrthogonalAxis=function(e,t){var n=b.normalize(e,d);return b.abs(n,n),t=n.x<=n.y?n.x<=n.z?b.clone(b.UNIT_X,t):b.clone(b.UNIT_Z,t):n.y<=n.z?b.clone(b.UNIT_Y,t):b.clone(b.UNIT_Z,t)},b.projectVector=function(e,t,n){var a=b.dot(e,t)/b.dot(t,t);return b.multiplyByScalar(t,a,n)},b.equals=function(e,t){return e===t||A.defined(e)&&A.defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},b.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},b.equalsEpsilon=function(e,t,n,a){return e===t||A.defined(e)&&A.defined(t)&&V.CesiumMath.equalsEpsilon(e.x,t.x,n,a)&&V.CesiumMath.equalsEpsilon(e.y,t.y,n,a)&&V.CesiumMath.equalsEpsilon(e.z,t.z,n,a)},b.cross=function(e,t,n){var a=e.x,i=e.y,r=e.z,u=t.x,o=t.y,d=t.z,s=i*d-r*o,h=r*u-a*d,f=a*o-i*u;return n.x=s,n.y=h,n.z=f,n},b.midpoint=function(e,t,n){return n.x=.5*(e.x+t.x),n.y=.5*(e.y+t.y),n.z=.5*(e.z+t.z),n},b.fromDegrees=function(e,t,n,a,i){return e=V.CesiumMath.toRadians(e),t=V.CesiumMath.toRadians(t),b.fromRadians(e,t,n,a,i)};var s=new b,h=new b,f=new b(40680631590769,40680631590769,40408299984661.445);b.fromRadians=function(e,t,n,a,i){n=c.defaultValue(n,0);var r=A.defined(a)?a.radiiSquared:f,u=Math.cos(t);s.x=u*Math.cos(e),s.y=u*Math.sin(e),s.z=Math.sin(t),s=b.normalize(s,s),b.multiplyComponents(r,s,h);var o=Math.sqrt(b.dot(s,h));return h=b.divideByScalar(h,o,h),s=b.multiplyByScalar(s,n,s),A.defined(i)||(i=new b),b.add(h,s,i)},b.fromDegreesArray=function(e,t,n){var a=e.length;A.defined(n)?n.length=a/2:n=new Array(a/2);for(var i=0;i<a;i+=2){var r=e[i],u=e[i+1],o=i/2;n[o]=b.fromDegrees(r,u,0,t,n[o])}return n},b.fromRadiansArray=function(e,t,n){var a=e.length;A.defined(n)?n.length=a/2:n=new Array(a/2);for(var i=0;i<a;i+=2){var r=e[i],u=e[i+1],o=i/2;n[o]=b.fromRadians(r,u,0,t,n[o])}return n},b.fromDegreesArrayHeights=function(e,t,n){var a=e.length;A.defined(n)?n.length=a/3:n=new Array(a/3);for(var i=0;i<a;i+=3){var r=e[i],u=e[i+1],o=e[i+2],d=i/3;n[d]=b.fromDegrees(r,u,o,t,n[d])}return n},b.fromRadiansArrayHeights=function(e,t,n){var a=e.length;A.defined(n)?n.length=a/3:n=new Array(a/3);for(var i=0;i<a;i+=3){var r=e[i],u=e[i+1],o=e[i+2],d=i/3;n[d]=b.fromRadians(r,u,o,t,n[d])}return n},b.ZERO=n.freezeObject(new b(0,0,0)),b.UNIT_X=n.freezeObject(new b(1,0,0)),b.UNIT_Y=n.freezeObject(new b(0,1,0)),b.UNIT_Z=n.freezeObject(new b(0,0,1)),b.prototype.clone=function(e){return b.clone(this,e)},b.prototype.equals=function(e){return b.equals(this,e)},b.prototype.equalsEpsilon=function(e,t,n){return b.equalsEpsilon(this,e,t,n)},b.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"};var I=new b,E=new b;function l(e,t,n,a,i){var r=e.x,u=e.y,o=e.z,d=t.x,s=t.y,h=t.z,f=r*r*d*d,l=u*u*s*s,c=o*o*h*h,m=f+l+c,y=Math.sqrt(1/m),p=b.multiplyByScalar(e,y,I);if(m<a)return isFinite(y)?b.clone(p,i):void 0;var g=n.x,x=n.y,M=n.z,w=E;w.x=p.x*g*2,w.y=p.y*x*2,w.z=p.z*M*2;var v,_,C,z,S,q,T,O=(1-y)*b.magnitude(e)/(.5*b.magnitude(w)),R=0;do{R=(v=f*(S=(_=1/(1+(O-=R)*g))*_)+l*(q=(C=1/(1+O*x))*C)+c*(T=(z=1/(1+O*M))*z)-1)/(-2*(f*(S*_)*g+l*(q*C)*x+c*(T*z)*M))}while(Math.abs(v)>V.CesiumMath.EPSILON12);return A.defined(i)?(i.x=r*_,i.y=u*C,i.z=o*z,i):new b(r*_,u*C,o*z)}function m(e,t,n){this.longitude=c.defaultValue(e,0),this.latitude=c.defaultValue(t,0),this.height=c.defaultValue(n,0)}m.fromRadians=function(e,t,n,a){return n=c.defaultValue(n,0),A.defined(a)?(a.longitude=e,a.latitude=t,a.height=n,a):new m(e,t,n)},m.fromDegrees=function(e,t,n,a){return e=V.CesiumMath.toRadians(e),t=V.CesiumMath.toRadians(t),m.fromRadians(e,t,n,a)};var y=new b,p=new b,g=new b,x=new b(1/6378137,1/6378137,1/6356752.314245179),M=new b(1/40680631590769,1/40680631590769,1/40408299984661.445),w=V.CesiumMath.EPSILON1;function v(e,t,n,a){t=c.defaultValue(t,0),n=c.defaultValue(n,0),a=c.defaultValue(a,0),e._radii=new b(t,n,a),e._radiiSquared=new b(t*t,n*n,a*a),e._radiiToTheFourth=new b(t*t*t*t,n*n*n*n,a*a*a*a),e._oneOverRadii=new b(0===t?0:1/t,0===n?0:1/n,0===a?0:1/a),e._oneOverRadiiSquared=new b(0===t?0:1/(t*t),0===n?0:1/(n*n),0===a?0:1/(a*a)),e._minimumRadius=Math.min(t,n,a),e._maximumRadius=Math.max(t,n,a),e._centerToleranceSquared=V.CesiumMath.EPSILON1,0!==e._radiiSquared.z&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function _(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,v(this,e,t,n)}m.fromCartesian=function(e,t,n){var a=A.defined(t)?t.oneOverRadii:x,i=A.defined(t)?t.oneOverRadiiSquared:M,r=l(e,a,i,A.defined(t)?t._centerToleranceSquared:w,p);if(A.defined(r)){var u=b.multiplyComponents(r,i,y);u=b.normalize(u,u);var o=b.subtract(e,r,g),d=Math.atan2(u.y,u.x),s=Math.asin(u.z),h=V.CesiumMath.sign(b.dot(o,e))*b.magnitude(o);return A.defined(n)?(n.longitude=d,n.latitude=s,n.height=h,n):new m(d,s,h)}},m.toCartesian=function(e,t,n){return b.fromRadians(e.longitude,e.latitude,e.height,t,n)},m.clone=function(e,t){if(A.defined(e))return A.defined(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new m(e.longitude,e.latitude,e.height)},m.equals=function(e,t){return e===t||A.defined(e)&&A.defined(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},m.equalsEpsilon=function(e,t,n){return e===t||A.defined(e)&&A.defined(t)&&Math.abs(e.longitude-t.longitude)<=n&&Math.abs(e.latitude-t.latitude)<=n&&Math.abs(e.height-t.height)<=n},m.ZERO=n.freezeObject(new m(0,0,0)),m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m.prototype.equalsEpsilon=function(e,t){return m.equalsEpsilon(this,e,t)},m.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a.defineProperties(_.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),_.clone=function(e,t){if(A.defined(e)){var n=e._radii;return A.defined(t)?(b.clone(n,t._radii),b.clone(e._radiiSquared,t._radiiSquared),b.clone(e._radiiToTheFourth,t._radiiToTheFourth),b.clone(e._oneOverRadii,t._oneOverRadii),b.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new _(n.x,n.y,n.z)}},_.fromCartesian3=function(e,t){return A.defined(t)||(t=new _),A.defined(e)&&v(t,e.x,e.y,e.z),t},_.WGS84=n.freezeObject(new _(6378137,6378137,6356752.314245179)),_.UNIT_SPHERE=n.freezeObject(new _(1,1,1)),_.MOON=n.freezeObject(new _(V.CesiumMath.LUNAR_RADIUS,V.CesiumMath.LUNAR_RADIUS,V.CesiumMath.LUNAR_RADIUS)),_.prototype.clone=function(e){return _.clone(this,e)},_.packedLength=b.packedLength,_.pack=function(e,t,n){return n=c.defaultValue(n,0),b.pack(e._radii,t,n),t},_.unpack=function(e,t,n){t=c.defaultValue(t,0);var a=b.unpack(e,t);return _.fromCartesian3(a,n)},_.prototype.geocentricSurfaceNormal=b.normalize,_.prototype.geodeticSurfaceNormalCartographic=function(e,t){var n=e.longitude,a=e.latitude,i=Math.cos(a),r=i*Math.cos(n),u=i*Math.sin(n),o=Math.sin(a);return A.defined(t)||(t=new b),t.x=r,t.y=u,t.z=o,b.normalize(t,t)},_.prototype.geodeticSurfaceNormal=function(e,t){return A.defined(t)||(t=new b),t=b.multiplyComponents(e,this._oneOverRadiiSquared,t),b.normalize(t,t)};var C=new b,z=new b;_.prototype.cartographicToCartesian=function(e,t){var n=C,a=z;this.geodeticSurfaceNormalCartographic(e,n),b.multiplyComponents(this._radiiSquared,n,a);var i=Math.sqrt(b.dot(n,a));return b.divideByScalar(a,i,a),b.multiplyByScalar(n,e.height,n),A.defined(t)||(t=new b),b.add(a,n,t)},_.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;A.defined(t)?t.length=n:t=new Array(n);for(var a=0;a<n;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var S=new b,q=new b,T=new b;function O(e,t,n,a){this.west=c.defaultValue(e,0),this.south=c.defaultValue(t,0),this.east=c.defaultValue(n,0),this.north=c.defaultValue(a,0)}_.prototype.cartesianToCartographic=function(e,t){var n=this.scaleToGeodeticSurface(e,q);if(A.defined(n)){var a=this.geodeticSurfaceNormal(n,S),i=b.subtract(e,n,T),r=Math.atan2(a.y,a.x),u=Math.asin(a.z),o=V.CesiumMath.sign(b.dot(i,e))*b.magnitude(i);return A.defined(t)?(t.longitude=r,t.latitude=u,t.height=o,t):new m(r,u,o)}},_.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;A.defined(t)?t.length=n:t=new Array(n);for(var a=0;a<n;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},_.prototype.scaleToGeodeticSurface=function(e,t){return l(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},_.prototype.scaleToGeocentricSurface=function(e,t){A.defined(t)||(t=new b);var n=e.x,a=e.y,i=e.z,r=this._oneOverRadiiSquared,u=1/Math.sqrt(n*n*r.x+a*a*r.y+i*i*r.z);return b.multiplyByScalar(e,u,t)},_.prototype.transformPositionToScaledSpace=function(e,t){return A.defined(t)||(t=new b),b.multiplyComponents(e,this._oneOverRadii,t)},_.prototype.transformPositionFromScaledSpace=function(e,t){return A.defined(t)||(t=new b),b.multiplyComponents(e,this._radii,t)},_.prototype.equals=function(e){return this===e||A.defined(e)&&b.equals(this._radii,e._radii)},_.prototype.toString=function(){return this._radii.toString()},_.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,t,n){t=c.defaultValue(t,0);var a=this._squaredXOverSquaredZ;if(A.defined(n)||(n=new b),n.x=0,n.y=0,n.z=e.z*(1-a),!(Math.abs(n.z)>=this._radii.z-t))return n},a.defineProperties(O.prototype,{width:{get:function(){return O.computeWidth(this)}},height:{get:function(){return O.computeHeight(this)}}}),O.packedLength=4,O.pack=function(e,t,n){return n=c.defaultValue(n,0),t[n++]=e.west,t[n++]=e.south,t[n++]=e.east,t[n]=e.north,t},O.unpack=function(e,t,n){return t=c.defaultValue(t,0),A.defined(n)||(n=new O),n.west=e[t++],n.south=e[t++],n.east=e[t++],n.north=e[t],n},O.computeWidth=function(e){var t=e.east,n=e.west;return t<n&&(t+=V.CesiumMath.TWO_PI),t-n},O.computeHeight=function(e){return e.north-e.south},O.fromDegrees=function(e,t,n,a,i){return e=V.CesiumMath.toRadians(c.defaultValue(e,0)),t=V.CesiumMath.toRadians(c.defaultValue(t,0)),n=V.CesiumMath.toRadians(c.defaultValue(n,0)),a=V.CesiumMath.toRadians(c.defaultValue(a,0)),A.defined(i)?(i.west=e,i.south=t,i.east=n,i.north=a,i):new O(e,t,n,a)},O.fromRadians=function(e,t,n,a,i){return A.defined(i)?(i.west=c.defaultValue(e,0),i.south=c.defaultValue(t,0),i.east=c.defaultValue(n,0),i.north=c.defaultValue(a,0),i):new O(e,t,n,a)},O.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,r=-Number.MAX_VALUE,u=Number.MAX_VALUE,o=-Number.MAX_VALUE,d=0,s=e.length;d<s;d++){var h=e[d];n=Math.min(n,h.longitude),a=Math.max(a,h.longitude),u=Math.min(u,h.latitude),o=Math.max(o,h.latitude);var f=0<=h.longitude?h.longitude:h.longitude+V.CesiumMath.TWO_PI;i=Math.min(i,f),r=Math.max(r,f)}return r-i<a-n&&(n=i,(a=r)>V.CesiumMath.PI&&(a-=V.CesiumMath.TWO_PI),n>V.CesiumMath.PI&&(n-=V.CesiumMath.TWO_PI)),A.defined(t)?(t.west=n,t.south=u,t.east=a,t.north=o,t):new O(n,u,a,o)},O.fromCartesianArray=function(e,t,n){t=c.defaultValue(t,_.WGS84);for(var a=Number.MAX_VALUE,i=-Number.MAX_VALUE,r=Number.MAX_VALUE,u=-Number.MAX_VALUE,o=Number.MAX_VALUE,d=-Number.MAX_VALUE,s=0,h=e.length;s<h;s++){var f=t.cartesianToCartographic(e[s]);a=Math.min(a,f.longitude),i=Math.max(i,f.longitude),o=Math.min(o,f.latitude),d=Math.max(d,f.latitude);var l=0<=f.longitude?f.longitude:f.longitude+V.CesiumMath.TWO_PI;r=Math.min(r,l),u=Math.max(u,l)}return u-r<i-a&&(a=r,(i=u)>V.CesiumMath.PI&&(i-=V.CesiumMath.TWO_PI),a>V.CesiumMath.PI&&(a-=V.CesiumMath.TWO_PI)),A.defined(n)?(n.west=a,n.south=o,n.east=i,n.north=d,n):new O(a,o,i,d)},O.clone=function(e,t){if(A.defined(e))return A.defined(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new O(e.west,e.south,e.east,e.north)},O.equalsEpsilon=function(e,t,n){return e===t||A.defined(e)&&A.defined(t)&&Math.abs(e.west-t.west)<=n&&Math.abs(e.south-t.south)<=n&&Math.abs(e.east-t.east)<=n&&Math.abs(e.north-t.north)<=n},O.prototype.clone=function(e){return O.clone(this,e)},O.prototype.equals=function(e){return O.equals(this,e)},O.equals=function(e,t){return e===t||A.defined(e)&&A.defined(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},O.prototype.equalsEpsilon=function(e,t){return O.equalsEpsilon(this,e,t)},O.validate=function(e){},O.southwest=function(e,t){return A.defined(t)?(t.longitude=e.west,t.latitude=e.south,t.height=0,t):new m(e.west,e.south)},O.northwest=function(e,t){return A.defined(t)?(t.longitude=e.west,t.latitude=e.north,t.height=0,t):new m(e.west,e.north)},O.northeast=function(e,t){return A.defined(t)?(t.longitude=e.east,t.latitude=e.north,t.height=0,t):new m(e.east,e.north)},O.southeast=function(e,t){return A.defined(t)?(t.longitude=e.east,t.latitude=e.south,t.height=0,t):new m(e.east,e.south)},O.center=function(e,t){var n=e.east,a=e.west;n<a&&(n+=V.CesiumMath.TWO_PI);var i=V.CesiumMath.negativePiToPi(.5*(a+n)),r=.5*(e.south+e.north);return A.defined(t)?(t.longitude=i,t.latitude=r,t.height=0,t):new m(i,r)},O.intersection=function(e,t,n){var a=e.east,i=e.west,r=t.east,u=t.west;a<i&&0<r?a+=V.CesiumMath.TWO_PI:r<u&&0<a&&(r+=V.CesiumMath.TWO_PI),a<i&&u<0?u+=V.CesiumMath.TWO_PI:r<u&&i<0&&(i+=V.CesiumMath.TWO_PI);var o=V.CesiumMath.negativePiToPi(Math.max(i,u)),d=V.CesiumMath.negativePiToPi(Math.min(a,r));if(!((e.west<e.east||t.west<t.east)&&d<=o)){var s=Math.max(e.south,t.south),h=Math.min(e.north,t.north);if(!(h<=s))return A.defined(n)?(n.west=o,n.south=s,n.east=d,n.north=h,n):new O(o,s,d,h)}},O.simpleIntersection=function(e,t,n){var a=Math.max(e.west,t.west),i=Math.max(e.south,t.south),r=Math.min(e.east,t.east),u=Math.min(e.north,t.north);if(!(u<=i||r<=a))return A.defined(n)?(n.west=a,n.south=i,n.east=r,n.north=u,n):new O(a,i,r,u)},O.union=function(e,t,n){A.defined(n)||(n=new O);var a=e.east,i=e.west,r=t.east,u=t.west;a<i&&0<r?a+=V.CesiumMath.TWO_PI:r<u&&0<a&&(r+=V.CesiumMath.TWO_PI),a<i&&u<0?u+=V.CesiumMath.TWO_PI:r<u&&i<0&&(i+=V.CesiumMath.TWO_PI);var o=V.CesiumMath.convertLongitudeRange(Math.min(i,u)),d=V.CesiumMath.convertLongitudeRange(Math.max(a,r));return n.west=o,n.south=Math.min(e.south,t.south),n.east=d,n.north=Math.max(e.north,t.north),n},O.expand=function(e,t,n){return A.defined(n)||(n=new O),n.west=Math.min(e.west,t.longitude),n.south=Math.min(e.south,t.latitude),n.east=Math.max(e.east,t.longitude),n.north=Math.max(e.north,t.latitude),n},O.contains=function(e,t){var n=t.longitude,a=t.latitude,i=e.west,r=e.east;return r<i&&(r+=V.CesiumMath.TWO_PI,n<0&&(n+=V.CesiumMath.TWO_PI)),(i<n||V.CesiumMath.equalsEpsilon(n,i,V.CesiumMath.EPSILON14))&&(n<r||V.CesiumMath.equalsEpsilon(n,r,V.CesiumMath.EPSILON14))&&a>=e.south&&a<=e.north};var R=new m;function P(e,t){this.x=c.defaultValue(e,0),this.y=c.defaultValue(t,0)}O.subsample=function(e,t,n,a){t=c.defaultValue(t,_.WGS84),n=c.defaultValue(n,0),A.defined(a)||(a=[]);var i=0,r=e.north,u=e.south,o=e.east,d=e.west,s=R;s.height=n,s.longitude=d,s.latitude=r,a[i]=t.cartographicToCartesian(s,a[i]),i++,s.longitude=o,a[i]=t.cartographicToCartesian(s,a[i]),i++,s.latitude=u,a[i]=t.cartographicToCartesian(s,a[i]),i++,s.longitude=d,a[i]=t.cartographicToCartesian(s,a[i]),i++,s.latitude=r<0?r:0<u?u:0;for(var h=1;h<8;++h)s.longitude=-Math.PI+h*V.CesiumMath.PI_OVER_TWO,O.contains(e,s)&&(a[i]=t.cartographicToCartesian(s,a[i]),i++);return 0===s.latitude&&(s.longitude=d,a[i]=t.cartographicToCartesian(s,a[i]),i++,s.longitude=o,a[i]=t.cartographicToCartesian(s,a[i]),i++),a.length=i,a},O.MAX_VALUE=n.freezeObject(new O(-Math.PI,-V.CesiumMath.PI_OVER_TWO,Math.PI,V.CesiumMath.PI_OVER_TWO)),P.fromElements=function(e,t,n){return A.defined(n)?(n.x=e,n.y=t,n):new P(e,t)},P.fromCartesian3=P.clone=function(e,t){if(A.defined(e))return A.defined(t)?(t.x=e.x,t.y=e.y,t):new P(e.x,e.y)},P.fromCartesian4=P.clone,P.packedLength=2,P.pack=function(e,t,n){return n=c.defaultValue(n,0),t[n++]=e.x,t[n]=e.y,t},P.unpack=function(e,t,n){return t=c.defaultValue(t,0),A.defined(n)||(n=new P),n.x=e[t++],n.y=e[t],n},P.packArray=function(e,t){var n=e.length;A.defined(t)?t.length=2*n:t=new Array(2*n);for(var a=0;a<n;++a)P.pack(e[a],t,2*a);return t},P.unpackArray=function(e,t){var n=e.length;A.defined(t)?t.length=n/2:t=new Array(n/2);for(var a=0;a<n;a+=2){var i=a/2;t[i]=P.unpack(e,a,t[i])}return t},P.fromArray=P.unpack,P.maximumComponent=function(e){return Math.max(e.x,e.y)},P.minimumComponent=function(e){return Math.min(e.x,e.y)},P.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},P.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},P.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},P.magnitude=function(e){return Math.sqrt(P.magnitudeSquared(e))};var N=new P;P.distance=function(e,t){return P.subtract(e,t,N),P.magnitude(N)},P.distanceSquared=function(e,t){return P.subtract(e,t,N),P.magnitudeSquared(N)},P.normalize=function(e,t){var n=P.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t},P.dot=function(e,t){return e.x*t.x+e.y*t.y},P.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n},P.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n},P.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n},P.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n},P.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n},P.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n},P.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},P.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var U=new P;P.lerp=function(e,t,n,a){return P.multiplyByScalar(t,n,U),a=P.multiplyByScalar(e,1-n,a),P.add(U,a,a)};var L=new P,k=new P;P.angleBetween=function(e,t){return P.normalize(e,L),P.normalize(t,k),V.CesiumMath.acosClamped(P.dot(L,k))};var W=new P;P.mostOrthogonalAxis=function(e,t){var n=P.normalize(e,W);return P.abs(n,n),t=n.x<=n.y?P.clone(P.UNIT_X,t):P.clone(P.UNIT_Y,t)},P.equals=function(e,t){return e===t||A.defined(e)&&A.defined(t)&&e.x===t.x&&e.y===t.y},P.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},P.equalsEpsilon=function(e,t,n,a){return e===t||A.defined(e)&&A.defined(t)&&V.CesiumMath.equalsEpsilon(e.x,t.x,n,a)&&V.CesiumMath.equalsEpsilon(e.y,t.y,n,a)},P.ZERO=n.freezeObject(new P(0,0)),P.UNIT_X=n.freezeObject(new P(1,0)),P.UNIT_Y=n.freezeObject(new P(0,1)),P.prototype.clone=function(e){return P.clone(this,e)},P.prototype.equals=function(e){return P.equals(this,e)},P.prototype.equalsEpsilon=function(e,t,n){return P.equalsEpsilon(this,e,t,n)},P.prototype.toString=function(){return"("+this.x+", "+this.y+")"},e.Cartesian2=P,e.Cartesian3=b,e.Cartographic=m,e.Ellipsoid=_,e.Rectangle=O});
