---
layout: docs
title: Browsers and devices
description: Learn about the browsers and devices, from modern to old, that are supported by Bootstrap Table, including known quirks and bugs for each.
group: getting-started
toc: true
---

## Supported browsers

Bootstrap Table supports the **latest, stable releases** of all major browsers and platforms. On Windows, **we support Internet Explorer 10-11 / Microsoft Edge**.

Alternative browsers which use the latest version of WebKit, Blink, or Gecko, whether directly or via the platform's web view API, are not explicitly supported. However, Bootstrap Table should (in most cases) display and function correctly in these browsers. More specific support information is provided below.

You can find our supported range of browsers and their versions [in our `.browserslistrc file`]({{ site.repo }}/blob/{{ site.current_version }}/.browserslistrc):

```
# https://github.com/browserslist/browserslist#readme

>= 1%
last 1 major version
not dead
Chrome >= 45
Firefox >= 38
Edge >= 12
Explorer >= 10
iOS >= 9
Safari >= 9
Android >= 4.4
Opera >= 30
```

Because Bootstrap Table is designed for Bootstrap, we will try to be consistent with Bootstrap in browsers and devices compatibility. You can check out the [browsers-devices of Bootstrap](https://getbootstrap.com/docs/4.2/getting-started/browsers-devices/) for more detail.
