/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures.worker;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.fao.geonet.harvester.wfsfeatures.worker.OwsUtils;
import org.fao.geonet.harvester.wfsfeatures.worker.WFSClientWithStrategyInvestigator;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.feature.type.FeatureTypeFactory;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.http.HTTPClient;
import org.geotools.ows.ServiceException;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;

public class WFSDataStoreWithStrategyInvestigator
extends WFSDataStoreFactory {
    private String describeFeatureTypeUrl;

    public void init(String url, String typeName, String version) throws Exception {
        this.describeFeatureTypeUrl = new OwsUtils().getDescribeFeatureTypeUrl(url, typeName, version);
    }

    public WFSDataStore createDataStore(Map params) throws IOException {
        WFSClientWithStrategyInvestigator wfsClient;
        WFSConfig config = WFSConfig.fromParams((Map)params);
        String user = config.getUser();
        String password = config.getPassword();
        if (user == null && password != null || config.getPassword() == null && config.getUser() != null) {
            throw new IOException("Cannot define only one of USERNAME or PASSWORD, must define both or neither");
        }
        URL capabilitiesURL = (URL)URL.lookUp(params);
        HTTPClient http = this.getHttpClient(params);
        http.setTryGzip(config.isTryGZIP());
        http.setUser(config.getUser());
        http.setPassword(config.getPassword());
        int timeoutMillis = config.getTimeoutMillis();
        http.setConnectTimeout(timeoutMillis / 1000);
        http.setReadTimeout(timeoutMillis / 1000);
        try {
            wfsClient = new WFSClientWithStrategyInvestigator(capabilitiesURL, http, config, this.describeFeatureTypeUrl);
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
        WFSDataStore dataStore = new WFSDataStore((WFSClient)wfsClient);
        dataStore.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
        dataStore.setGeometryFactory(new GeometryFactory((CoordinateSequenceFactory)PackedCoordinateSequenceFactory.DOUBLE_FACTORY));
        dataStore.setFeatureTypeFactory((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        dataStore.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
        dataStore.setDataStoreFactory((DataStoreFactorySpi)this);
        dataStore.setNamespaceURI(config.getNamespaceOverride());
        return dataStore;
    }
}

