/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.rlookup;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.rlookup.LookupItem;
import it.geosolutions.jaiext.rlookup.RangeLookupTable;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class RangeLookupOpImage
extends PointOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private final RangeLookupTable table;
    private final Number defaultValue;
    private final ROI roi;
    private final boolean hasDefault;
    private boolean hasROI;
    private Rectangle roiBounds;
    private PlanarImage roiImage;

    public RangeLookupOpImage(RenderedImage source, Map config, ImageLayout layout, RangeLookupTable table, Number defaultValue, ROI roi) {
        super(source, layout, config, true);
        this.table = table;
        this.defaultValue = defaultValue;
        this.hasDefault = defaultValue != null;
        this.roi = roi;
        boolean bl = this.hasROI = roi != null;
        if (this.hasROI) {
            this.roiBounds = roi.getBounds();
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiTile = this.roi.intersect((ROI)new ROIShape((Shape)srcRectExpanded));
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
                    }
                }
            }
        }
        if (roiDisjointTile) {
            int numBands = dest.getNumBands();
            double[] destNoData = new double[numBands];
            double nodata = this.hasDefault ? this.defaultValue.doubleValue() : 0.0;
            for (int i = 0; i < numBands; ++i) {
                destNoData[i] = nodata;
            }
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])destNoData);
            return;
        }
        RasterAccessor srcAcc = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor destAcc = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        this.doLookup(srcAcc, destAcc, roiIter, roiContainsTile);
    }

    private void doLookup(RasterAccessor srcAcc, RasterAccessor destAcc, RandomIter roiIter, boolean roiContainsTile) {
        switch (destAcc.getDataType()) {
            case 0: {
                this.lookupAsByteData(srcAcc, destAcc, roiIter, roiContainsTile);
                break;
            }
            case 3: {
                this.lookupAsIntData(srcAcc, destAcc, roiIter, roiContainsTile);
                break;
            }
            case 2: {
                this.lookupAsShortData(srcAcc, destAcc, roiIter, roiContainsTile);
                break;
            }
            case 1: {
                this.lookupAsUShortData(srcAcc, destAcc, roiIter, roiContainsTile);
                break;
            }
            case 4: {
                this.lookupAsFloatData(srcAcc, destAcc, roiIter, roiContainsTile);
                break;
            }
            case 5: {
                this.lookupAsDoubleData(srcAcc, destAcc, roiIter, roiContainsTile);
            }
        }
        if (destAcc.isDataCopy()) {
            destAcc.clampDataArrays();
            destAcc.copyDataToRaster();
        }
    }

    private void lookupAsByteData(RasterAccessor srcAcc, RasterAccessor destAcc, RandomIter roiIter, boolean roiContainsTile) {
        byte typedDefaultValue;
        byte[][] srcData = srcAcc.getByteDataArrays();
        byte[][] destData = destAcc.getByteDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range lastRange = null;
        byte destinationValue = typedDefaultValue = this.hasDefault ? (byte)this.defaultValue.byteValue() : (byte)-128;
        if (this.hasROI && !roiContainsTile) {
            int srcScanlineOffset = 0;
            int dstScanlineOffset = 0;
            int j = 0;
            int destY = destAcc.getY();
            while (j < destHeight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                int destX = destAcc.getX();
                while (i < destWidth) {
                    byte val;
                    int k;
                    if (!this.roiBounds.contains(destX, destY) || roiIter.getSample(destX, destY, 0) <= 0) {
                        for (k = 0; k < destBands; ++k) {
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = val = this.hasDefault ? typedDefaultValue : (byte)(srcData[k][srcPixelOffset + srcBandOffsets[k]] & 0xFF);
                        }
                    } else {
                        for (k = 0; k < destBands; ++k) {
                            val = (byte)(srcData[k][srcPixelOffset + srcBandOffsets[k]] & 0xFF);
                            if (lastRange == null || !lastRange.contains(val)) {
                                lastRange = null;
                                LookupItem item = this.table.getLookupItem(val);
                                if (item != null) {
                                    lastRange = item.getRange();
                                    destinationValue = ((Number)item.getValue()).byteValue();
                                } else {
                                    destinationValue = this.hasDefault ? typedDefaultValue : val;
                                }
                            }
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = destinationValue;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        } else {
            for (int k = 0; k < destBands; ++k) {
                byte[] destBandData = destData[k];
                byte[] srcBandData = srcData[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < destHeight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < destWidth; ++i) {
                        byte val = (byte)(srcBandData[srcPixelOffset] & 0xFF);
                        if (lastRange == null || !lastRange.contains(val)) {
                            lastRange = null;
                            LookupItem item = this.table.getLookupItem(val);
                            if (item != null) {
                                lastRange = item.getRange();
                                destinationValue = ((Number)item.getValue()).byteValue();
                            } else {
                                destinationValue = this.hasDefault ? typedDefaultValue : (byte)val;
                            }
                        }
                        destBandData[dstPixelOffset] = destinationValue;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void lookupAsShortData(RasterAccessor srcAcc, RasterAccessor destAcc, RandomIter roiIter, boolean roiContainsTile) {
        short typedDefaultValue;
        short[][] srcData = srcAcc.getShortDataArrays();
        short[][] destData = destAcc.getShortDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range lastRange = null;
        short destinationValue = typedDefaultValue = this.hasDefault ? (short)this.defaultValue.shortValue() : (short)Short.MIN_VALUE;
        if (this.hasROI && !roiContainsTile) {
            int srcScanlineOffset = 0;
            int dstScanlineOffset = 0;
            int j = 0;
            int destY = destAcc.getY();
            while (j < destHeight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                int destX = destAcc.getX();
                while (i < destWidth) {
                    short val;
                    int k;
                    if (!this.roiBounds.contains(destX, destY) || roiIter.getSample(destX, destY, 0) <= 0) {
                        for (k = 0; k < destBands; ++k) {
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = val = this.hasDefault ? typedDefaultValue : srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                    } else {
                        for (k = 0; k < destBands; ++k) {
                            val = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (lastRange == null || !lastRange.contains(val)) {
                                lastRange = null;
                                LookupItem item = this.table.getLookupItem(val);
                                if (item != null) {
                                    lastRange = item.getRange();
                                    destinationValue = ((Number)item.getValue()).shortValue();
                                } else {
                                    destinationValue = this.hasDefault ? typedDefaultValue : val;
                                }
                            }
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = destinationValue;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        } else {
            for (int k = 0; k < destBands; ++k) {
                short[] destBandData = destData[k];
                short[] srcBandData = srcData[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < destHeight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < destWidth; ++i) {
                        short val = srcBandData[srcPixelOffset];
                        if (lastRange == null || !lastRange.contains(val)) {
                            lastRange = null;
                            LookupItem item = this.table.getLookupItem(val);
                            if (item != null) {
                                lastRange = item.getRange();
                                destinationValue = ((Number)item.getValue()).shortValue();
                            } else {
                                destinationValue = this.hasDefault ? typedDefaultValue : val;
                            }
                        }
                        destBandData[dstPixelOffset] = destinationValue;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void lookupAsUShortData(RasterAccessor srcAcc, RasterAccessor destAcc, RandomIter roiIter, boolean roiContainsTile) {
        int typedDefaultValue;
        short[][] srcData = srcAcc.getShortDataArrays();
        short[][] destData = destAcc.getShortDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range lastRange = null;
        int destinationValue = typedDefaultValue = this.hasDefault ? this.defaultValue.shortValue() : 0;
        if (this.hasROI && !roiContainsTile) {
            int srcScanlineOffset = 0;
            int dstScanlineOffset = 0;
            int j = 0;
            int destY = destAcc.getY();
            while (j < destHeight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                int destX = destAcc.getX();
                while (i < destWidth) {
                    int val;
                    int k;
                    if (!this.roiBounds.contains(destX, destY) || roiIter.getSample(destX, destY, 0) <= 0) {
                        for (k = 0; k < destBands; ++k) {
                            val = this.hasDefault ? typedDefaultValue : srcData[k][srcPixelOffset] & 0xFFFF;
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = (short)val;
                        }
                    } else {
                        for (k = 0; k < destBands; ++k) {
                            val = srcData[k][srcPixelOffset] & 0xFFFF;
                            if (lastRange == null || !lastRange.contains(val)) {
                                lastRange = null;
                                LookupItem item = this.table.getLookupItem(val);
                                if (item != null) {
                                    lastRange = item.getRange();
                                    destinationValue = ((Number)item.getValue()).shortValue();
                                } else {
                                    destinationValue = (short)(this.hasDefault ? typedDefaultValue : (short)val);
                                }
                            }
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = destinationValue;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        } else {
            for (int k = 0; k < destBands; ++k) {
                short[] destBandData = destData[k];
                short[] srcBandData = srcData[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < destHeight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < destWidth; ++i) {
                        int val = srcBandData[srcPixelOffset] & 0xFFFF;
                        if (lastRange == null || !lastRange.contains(val)) {
                            lastRange = null;
                            LookupItem item = this.table.getLookupItem(val);
                            if (item != null) {
                                lastRange = item.getRange();
                                destinationValue = ((Number)item.getValue()).shortValue();
                            } else {
                                destinationValue = (short)(this.hasDefault ? typedDefaultValue : (short)val);
                            }
                        }
                        destBandData[dstPixelOffset] = destinationValue;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void lookupAsIntData(RasterAccessor srcAcc, RasterAccessor destAcc, RandomIter roiIter, boolean roiContainsTile) {
        int typedDefaultValue;
        int[][] srcData = srcAcc.getIntDataArrays();
        int[][] destData = destAcc.getIntDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range lastRange = null;
        int destinationValue = typedDefaultValue = this.hasDefault ? this.defaultValue.intValue() : Integer.MIN_VALUE;
        if (this.hasROI && !roiContainsTile) {
            int srcScanlineOffset = 0;
            int dstScanlineOffset = 0;
            int j = 0;
            int destY = destAcc.getY();
            while (j < destHeight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                int destX = destAcc.getX();
                while (i < destWidth) {
                    int val;
                    int k;
                    if (!this.roiBounds.contains(destX, destY) || roiIter.getSample(destX, destY, 0) <= 0) {
                        for (k = 0; k < destBands; ++k) {
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = val = this.hasDefault ? typedDefaultValue : srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                    } else {
                        for (k = 0; k < destBands; ++k) {
                            val = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (lastRange == null || !lastRange.contains(val)) {
                                lastRange = null;
                                LookupItem item = this.table.getLookupItem(val);
                                if (item != null) {
                                    lastRange = item.getRange();
                                    destinationValue = ((Number)item.getValue()).intValue();
                                } else {
                                    destinationValue = this.hasDefault ? typedDefaultValue : val;
                                }
                            }
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = destinationValue;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        } else {
            for (int k = 0; k < destBands; ++k) {
                int[] destBandData = destData[k];
                int[] srcBandData = srcData[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < destHeight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < destWidth; ++i) {
                        int val = srcBandData[srcPixelOffset];
                        if (lastRange == null || !lastRange.contains(val)) {
                            lastRange = null;
                            LookupItem item = this.table.getLookupItem(val);
                            if (item != null) {
                                lastRange = item.getRange();
                                destinationValue = ((Number)item.getValue()).intValue();
                            } else {
                                destinationValue = this.hasDefault ? typedDefaultValue : val;
                            }
                        }
                        destBandData[dstPixelOffset] = destinationValue;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void lookupAsFloatData(RasterAccessor srcAcc, RasterAccessor destAcc, RandomIter roiIter, boolean roiContainsTile) {
        float typedDefaultValue;
        float[][] srcData = srcAcc.getFloatDataArrays();
        float[][] destData = destAcc.getFloatDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range lastRange = null;
        float destinationValue = typedDefaultValue = this.hasDefault ? this.defaultValue.floatValue() : Float.NaN;
        if (this.hasROI && !roiContainsTile) {
            int srcScanlineOffset = 0;
            int dstScanlineOffset = 0;
            int j = 0;
            int destY = destAcc.getY();
            while (j < destHeight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                int destX = destAcc.getX();
                while (i < destWidth) {
                    float val;
                    int k;
                    if (!this.roiBounds.contains(destX, destY) || roiIter.getSample(destX, destY, 0) <= 0) {
                        for (k = 0; k < destBands; ++k) {
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = val = this.hasDefault ? typedDefaultValue : srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                    } else {
                        for (k = 0; k < destBands; ++k) {
                            val = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (lastRange == null || !lastRange.contains(val)) {
                                lastRange = null;
                                LookupItem item = this.table.getLookupItem(Float.valueOf(val));
                                if (item != null) {
                                    lastRange = item.getRange();
                                    destinationValue = ((Number)item.getValue()).floatValue();
                                } else {
                                    destinationValue = this.hasDefault ? typedDefaultValue : val;
                                }
                            }
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = destinationValue;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        } else {
            for (int k = 0; k < destBands; ++k) {
                float[] destBandData = destData[k];
                float[] srcBandData = srcData[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < destHeight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < destWidth; ++i) {
                        float val = srcBandData[srcPixelOffset];
                        if (lastRange == null || !lastRange.contains(val)) {
                            lastRange = null;
                            LookupItem item = this.table.getLookupItem(Float.valueOf(val));
                            if (item != null) {
                                lastRange = item.getRange();
                                destinationValue = ((Number)item.getValue()).floatValue();
                            } else {
                                destinationValue = this.hasDefault ? typedDefaultValue : val;
                            }
                        }
                        destBandData[dstPixelOffset] = destinationValue;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void lookupAsDoubleData(RasterAccessor srcAcc, RasterAccessor destAcc, RandomIter roiIter, boolean roiContainsTile) {
        double typedDefaultValue;
        double[][] srcData = srcAcc.getDoubleDataArrays();
        double[][] destData = destAcc.getDoubleDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range lastRange = null;
        double destinationValue = typedDefaultValue = this.hasDefault ? this.defaultValue.doubleValue() : Double.NaN;
        if (this.hasROI && !roiContainsTile) {
            int srcScanlineOffset = 0;
            int dstScanlineOffset = 0;
            int j = 0;
            int destY = destAcc.getY();
            while (j < destHeight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                int destX = destAcc.getX();
                while (i < destWidth) {
                    double val;
                    int k;
                    if (!this.roiBounds.contains(destX, destY) || roiIter.getSample(destX, destY, 0) <= 0) {
                        for (k = 0; k < destBands; ++k) {
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = val = this.hasDefault ? typedDefaultValue : srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                    } else {
                        for (k = 0; k < destBands; ++k) {
                            val = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (lastRange == null || !lastRange.contains(val)) {
                                lastRange = null;
                                LookupItem item = this.table.getLookupItem(val);
                                if (item != null) {
                                    lastRange = item.getRange();
                                    destinationValue = ((Number)item.getValue()).doubleValue();
                                } else {
                                    destinationValue = this.hasDefault ? typedDefaultValue : val;
                                }
                            }
                            destData[k][dstPixelOffset + dstBandOffsets[k]] = destinationValue;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        } else {
            for (int k = 0; k < destBands; ++k) {
                double[] destBandData = destData[k];
                double[] srcBandData = srcData[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < destHeight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < destWidth; ++i) {
                        double val = srcBandData[srcPixelOffset];
                        if (lastRange == null || !lastRange.contains(val)) {
                            lastRange = null;
                            LookupItem item = this.table.getLookupItem(val);
                            if (item != null) {
                                lastRange = item.getRange();
                                destinationValue = ((Number)item.getValue()).doubleValue();
                            } else {
                                destinationValue = this.hasDefault ? typedDefaultValue : val;
                            }
                        }
                        destBandData[dstPixelOffset] = destinationValue;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            RangeLookupOpImage rangeLookupOpImage = this;
            synchronized (rangeLookupOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }
}

