/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.languages.FeedbackLanguages;
import org.fao.geonet.util.LocalizedEmailComponent;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;

public class LocalizedEmail {
    private final Boolean isHtml;
    private final Map<LocalizedEmailComponent.ComponentType, LocalizedEmailComponent> components;
    private final String translationFollowsText;
    private static final String SUBJECT_DELIMITER = " | ";
    private static final String HTML_MESSAGE_DELIMITER = "<hr>";
    private static final String HTML_LINE_BREAK = "<br><br>";
    private static final String TEXT_MESSAGE_DELIMITER = "\n\n--------------------------------------------------------\n\n";
    private static final String TEXT_LINE_BREAK = "\n\n";

    public LocalizedEmail(Boolean isHtml) {
        this.isHtml = isHtml;
        FeedbackLanguages feedbackLanguages = (FeedbackLanguages)ApplicationContextHolder.get().getBean(FeedbackLanguages.class);
        this.translationFollowsText = feedbackLanguages.getTranslationFollowsText();
        this.components = new HashMap<LocalizedEmailComponent.ComponentType, LocalizedEmailComponent>();
    }

    public void addComponents(LocalizedEmailComponent ... newComponents) {
        for (LocalizedEmailComponent newComponent : newComponents) {
            if (newComponent == null) {
                throw new IllegalArgumentException("Null parameter not allowed");
            }
            this.components.put(newComponent.getComponentType(), newComponent);
        }
    }

    public String getParsedSubject(Locale[] feedbackLocales) {
        LinkedHashMap<Locale, String> subjects = this.components.get((Object)LocalizedEmailComponent.ComponentType.SUBJECT).getParsedMessagesMap(feedbackLocales);
        return String.join((CharSequence)SUBJECT_DELIMITER, subjects.values());
    }

    public String getParsedMessage(Locale[] feedbackLocales) {
        return this.getParsedMessage(feedbackLocales, null);
    }

    public String getParsedMessage(Locale[] feedbackLocales, Map<String, String> replacements) {
        String lineBreak;
        String messageDelimiter;
        LinkedHashMap<Locale, String> messages = this.components.get((Object)LocalizedEmailComponent.ComponentType.MESSAGE).getParsedMessagesMap(feedbackLocales, true);
        if (this.components.containsKey((Object)LocalizedEmailComponent.ComponentType.SALUTATION) && this.components.get((Object)LocalizedEmailComponent.ComponentType.SALUTATION) != null) {
            LinkedHashMap<Locale, String> salutations = this.components.get((Object)LocalizedEmailComponent.ComponentType.SALUTATION).getParsedMessagesMap(feedbackLocales);
            LinkedHashMap<Locale, CallSite> messagesWithSalutations = new LinkedHashMap<Locale, CallSite>();
            for (Map.Entry<Locale, String> entry : messages.entrySet()) {
                if (!salutations.containsKey(entry.getKey())) continue;
                String message2 = entry.getValue();
                String salutation = salutations.get(entry.getKey());
                if (replacements != null && !replacements.isEmpty()) {
                    for (Map.Entry<String, String> replacement : replacements.entrySet()) {
                        salutation = salutation.replace(replacement.getKey(), replacement.getValue());
                    }
                }
                messagesWithSalutations.put(entry.getKey(), (CallSite)((Object)(salutation + message2)));
            }
            messages = messagesWithSalutations;
        }
        if (this.isHtml.booleanValue()) {
            messageDelimiter = HTML_MESSAGE_DELIMITER;
            lineBreak = HTML_LINE_BREAK;
            messages.replaceAll((locale, message) -> "<div lang=\"" + XslUtil.twoCharLangCode(locale.getISO3Language()) + "\">" + message + "</div>");
        } else {
            messageDelimiter = TEXT_MESSAGE_DELIMITER;
            lineBreak = TEXT_LINE_BREAK;
        }
        Object emailMessage = String.join((CharSequence)messageDelimiter, messages.values());
        if (messages.size() > 1 && !StringUtils.isBlank((String)this.translationFollowsText)) {
            emailMessage = this.translationFollowsText + lineBreak + (String)emailMessage;
        }
        if (this.isHtml.booleanValue()) {
            if (((String)emailMessage).contains("<html>") || ((String)emailMessage).contains("<body>")) {
                Log.warning((String)"geonetwork.localizedemail", (Object)"Multilingual emails are unsupported for HTML emails with messages containing <html> or <body> tags. Reverting to first specified locale.");
                return messages.get(feedbackLocales[0]);
            }
            emailMessage = "<html><body>" + (String)emailMessage + "</body></html>";
        }
        return emailMessage;
    }
}

