/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.main;

import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.fao.geonet.services.util.z3950.DefaultContextSetCQLString;
import org.fao.geonet.services.util.z3950.GNExplainInfoDTO;
import org.fao.geonet.services.util.z3950.SRUDiag;
import org.fao.geonet.services.util.z3950.SRUParamTestDBO;
import org.fao.geonet.services.util.z3950.SRUParamTester;
import org.fao.geonet.utils.Log;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jzkit.search.ExplainInformationDTO;
import org.jzkit.search.LandscapeSpecification;
import org.jzkit.search.SearchSessionFactory;
import org.jzkit.search.StatelessSearchResultsPageDTO;
import org.jzkit.search.landscape.SimpleLandscapeSpecification;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.jzkit.search.util.RecordModel.ArchetypeRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.springframework.context.ApplicationContext;

public class SRUSearch
implements Service {
    public static final int SRU_records_per_page = 10;
    public static final String OP = "operation";
    public static final String OP_SR_QUERY = "query";
    public static final String OP_SR_VERSION = "version";
    public static final String OP_SR_STYLESH = "stylesheet";
    public static final String OP_SR_STARTREC = "startrecord";
    public static final String OP_SR_MAXREC = "maximumrecords";
    public static final String OP_SR_RECPACK = "recordpacking";
    public static final String OP_SR_RECSCHEMA = "recordschema";
    public static final String OP_SR_RECXPATH = "recordxpath";
    public static final String OP_SR_SORTKEYS = "sortkeys";
    public static final String OP_SR_EXTRADATA = "extrarequestdata";
    public static final String OP_EXPL_RECPACK = "query";
    public static final String OP_EXPL_VERSION = "version";
    public static final String OP_EXPL_STYLESH = "stylesheet";
    public static final int ERROR_OP_NOT_SUPPORTED = 1;
    public static final int ERROR_VERSION_NOT_SUPPORTED = 2;
    public static final int ERROR_SRUATTRIBUTE_NOT_SUPPORTED = 3;
    public static final int ERROR_SRUOP_NOT_SUPPORTED = 4;
    private static RecordFormatSpecification request_spec = new ArchetypeRecordFormatSpecification("F");
    private SearchSessionFactory searchsessionfact;
    private Hashtable<String, String> contextSets;
    private SRUParamTester paramtester = new SRUParamTester();

    private static void addToDiag(Element diagnostics, String uri, String message, String details) {
        Element diagnostic = new Element("diagnostic");
        diagnostic.addContent((Content)new Element("uri").setText(uri));
        diagnostic.addContent((Content)new Element("message").setText(message));
        diagnostic.addContent((Content)new Element("details").setText(details));
        diagnostics.addContent((Content)diagnostic);
    }

    @Override
    public void init(Path appPath, ServiceConfig config) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.sru")) {
            Log.debug((String)"geonetwork.sru", (Object)"SRUsearch::init");
        }
        this.contextSets = new Hashtable();
        this.contextSets.put("dc", "info:srw/cql-context-set/1/dc-v1.1");
        this.contextSets.put("gils", "info:srw/cql-context-set/14/gils-v1.0");
        this.contextSets.put("geo", "http://??");
        this.contextSets.put("cql", "info:srw/cql-context-set/1/cql-v1.2");
        this.contextSets.put("rec", "info:srw/cql-context-set/2/rec-1.1");
    }

    @Override
    public Element exec(Element params, ServiceContext context) throws Exception {
        Hashtable<String, String> myparams = this.parseArgs(params.getChildren());
        if (Log.isDebugEnabled((String)"geonetwork.sru")) {
            Log.debug((String)"geonetwork.sru", (Object)("SRUsearch::exec op:" + myparams.get(OP) + " version " + myparams.get("version")));
        }
        if (!myparams.containsKey(OP)) {
            myparams.put(OP, "explain");
        }
        String op = myparams.get(OP);
        Element ret = null;
        if (op.equalsIgnoreCase("searchretrieve")) {
            ret = this.processSearchRetrieve(myparams, context);
        } else if (op.equalsIgnoreCase("explain")) {
            ret = this.processExplain(myparams, context);
        } else if (op.equalsIgnoreCase("scan")) {
            ret = this.processScan(myparams, context);
        } else {
            ret = this.processExplain(myparams, context);
            op = "explain";
        }
        ret.addContent((Content)new Element("myop").setText(op.toLowerCase()));
        return ret;
    }

    private Element processScan(Hashtable<String, String> params, ServiceContext context) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.sru")) {
            Log.debug((String)"geonetwork.sru", (Object)"processScan");
        }
        Element response = new Element("response");
        Element diagnostics = this.processDiag(params, "scan");
        if (diagnostics != null) {
            response.addContent((Content)diagnostics);
        }
        return response;
    }

    private Element processExplain(Hashtable<String, String> params, ServiceContext context) throws Exception {
        Element diagnostics;
        if (Log.isDebugEnabled((String)"geonetwork.sru")) {
            Log.debug((String)"geonetwork.sru", (Object)"processExplain");
        }
        SearchSessionFactory search_session_factory = this.getSearchSession(context);
        ExplainInformationDTO explain = search_session_factory.explain();
        Hashtable<String, Boolean> seenContextSets = new Hashtable<String, Boolean>();
        Element response = new Element("response");
        String myop = "explain";
        if (params.containsKey(OP)) {
            myop = params.get(OP);
        }
        if ((diagnostics = this.processDiag(params, myop)) != null) {
            response.addContent((Content)diagnostics);
        }
        response.setAttribute(new Attribute("servername", context.getIpAddress()));
        response.setAttribute(new Attribute("sruuri", context.getBaseUrl() + "/srv/" + context.getLanguage() + "/" + context.getService()));
        response.setAttribute(new Attribute("records_per_page", "10"));
        Element indices = new Element("indices");
        for (Object o : explain.getDatabaseInfo()) {
            GNExplainInfoDTO ex = (GNExplainInfoDTO)o;
            Element index = new Element("index");
            index.setAttribute("id", ex.getId());
            for (String key : ex.getMappings().keySet()) {
                Element map = new Element("map");
                String contextSet = ex.getMappings().get(key);
                map.setAttribute("set", contextSet);
                map.setAttribute("text", key);
                seenContextSets.put(ex.getMappings().get(key), true);
                index.addContent((Content)map);
            }
            indices.addContent((Content)index);
        }
        Element sets = new Element("sets");
        Enumeration enu = seenContextSets.keys();
        while (enu.hasMoreElements()) {
            Element set = new Element("set");
            String namespace = (String)enu.nextElement();
            String url = "http://???";
            if (this.contextSets.containsKey(namespace)) {
                url = this.contextSets.get(namespace);
            }
            set.setAttribute(new Attribute("namespace", namespace));
            set.setAttribute(new Attribute("url", url));
            sets.addContent((Content)set);
        }
        response.addContent((Content)sets);
        response.addContent((Content)indices);
        return response;
    }

    private Element processSearchRetrieve(Hashtable<String, String> params, ServiceContext context) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.sru")) {
            Log.debug((String)"geonetwork.sru", (Object)"processSearchRetrieve");
        }
        Element response = new Element("response");
        Element diagnostics = this.processDiag(params, "searchretrieve");
        if (diagnostics != null) {
            response.addContent((Content)diagnostics);
            return response;
        }
        try {
            String record_schema;
            int num_hits_per_page = 10;
            int first_record = 1;
            if (params.get(OP_SR_MAXREC) != null) {
                num_hits_per_page = Integer.parseInt(params.get(OP_SR_MAXREC));
            }
            if (params.get(OP_SR_STARTREC) != null) {
                first_record = Integer.parseInt(params.get(OP_SR_STARTREC));
            }
            if ((record_schema = params.get(OP_SR_RECSCHEMA)) == null) {
                record_schema = "meta";
            }
            String query = params.get("query");
            ExplicitRecordFormatSpecification display_spec = new ExplicitRecordFormatSpecification("xml", "", "f");
            if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                Log.debug((String)"geonetwork.sru", (Object)"getting reference to search session factory");
            }
            SimpleLandscapeSpecification landscape = new SimpleLandscapeSpecification("geonetwork");
            DefaultContextSetCQLString model = new DefaultContextSetCQLString(query, "geo", "cql", "geo");
            SearchSessionFactory search_session_factory = this.getSearchSession(context);
            if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                Log.debug((String)"geonetwork.sru", (Object)"Calling search_session_factory.getResultsPageFor");
            }
            StatelessSearchResultsPageDTO result = search_session_factory.getResultsPageFor(null, (QueryModel)model, (LandscapeSpecification)landscape, first_record, num_hits_per_page, request_spec, display_spec, null);
            if (Log.isDebugEnabled((String)"geonetwork.sru")) {
                Log.debug((String)"geonetwork.sru", (Object)("Call to getResultsPageFor completed : " + result));
            }
            Element myresponse = new Element("sruresponse");
            response.addContent((Content)myresponse);
            int num_records = 0;
            String res_id = "";
            long idle = 0L;
            if (result.records != null && result.records.length > 0) {
                DOMBuilder builder = new DOMBuilder();
                num_records = result.records.length;
                res_id = result.result_set_id;
                idle = result.result_set_idle_time;
                for (int i = 0; i < result.records.length; ++i) {
                    Element elem = new Element("record");
                    elem.setAttribute(new Attribute("recordPosition", "" + first_record + i));
                    ExplicitRecordFormatSpecification res = result.records[i].getFormatSpecification();
                    if (!res.toString().equals(display_spec.toString())) {
                        Log.error((String)"geonetwork.sru", (Object)("error, format specification " + result.records[i].getFormatSpecification() + " does not correspond to " + display_spec + " :" + result.records[i].getOriginalObject()));
                        SRUSearch.addToDiag(elem, "info:srw/diagnostic/1/67", "Record not available in this schema", result.records[i].getOriginalObject().toString());
                    } else if (result.records[i].getOriginalObject() instanceof Document) {
                        Document doc = (Document)result.records[i].getOriginalObject();
                        Element e = doc.getRootElement();
                        e.detach();
                        elem.addContent((Content)e);
                    } else if (result.records[i].getOriginalObject() instanceof org.w3c.dom.Document) {
                        org.w3c.dom.Document d = (org.w3c.dom.Document)result.records[i].getOriginalObject();
                        Document doc = builder.build(d);
                        Element e = doc.getRootElement();
                        e.detach();
                        elem.addContent((Content)e);
                    } else {
                        String errormsg = "error: could not decode reponse object of type: " + result.records[i].getOriginalObject().getClass().getName();
                        Log.error((String)"geonetwork.csw.search", (Object)errormsg);
                        SRUSearch.addToDiag(elem, "info:srw/diagnostic/1/71", "Unsupported record packing", errormsg);
                    }
                    myresponse.addContent((Content)elem);
                }
            }
            response.addContent((Content)new Element("numrec").setText("" + num_records));
            response.addContent((Content)new Element("idle").setText("" + idle));
            response.addContent((Content)new Element("id").setText(res_id));
        }
        catch (InvalidQueryException e) {
            diagnostics = new Element("diagnostics");
            SRUSearch.addToDiag(diagnostics, "info:srw/diagnostic/1/10", "Query syntax error", e.getMessage());
            Log.error((String)"geonetwork.sru", (Object)("InvalidQueryException" + e));
        }
        catch (SearchException e) {
            diagnostics = new Element("diagnostics");
            if (e.error_code == 1) {
                SRUSearch.addToDiag(diagnostics, "info:srw/diagnostic/1/16", "Unsupported index", e.getMessage());
            } else if (e.error_code == 2) {
                SRUSearch.addToDiag(diagnostics, "info:srw/diagnostic/1/1", "General system error", "Config error: " + e.getMessage());
            } else {
                SRUSearch.addToDiag(diagnostics, "info:srw/diagnostic/1/1", "General system error", e.getMessage());
            }
            Log.error((String)"geonetwork.sru", (Object)("SearchException" + e));
        }
        catch (Exception e) {
            if (diagnostics == null) {
                diagnostics = new Element("diagnostics");
            }
            SRUSearch.addToDiag(diagnostics, "info:srw/diagnostic/1/1", "General system error", e.toString());
            Log.error((String)"geonetwork.sru", (Object)("problem at backend interaction" + e));
        }
        if (diagnostics != null) {
            response.addContent((Content)diagnostics);
        }
        return response;
    }

    private Set<SRUDiag> getDiag(String op, Hashtable<String, String> params) {
        HashSet<SRUDiag> set = new HashSet<SRUDiag>();
        SRUParamTestDBO res = this.paramtester.testParams(op, params);
        for (String param : res.getArgNotSupported()) {
            set.add(new SRUDiag("info:srw/diagnostic/1/8", "Unsupported Parameter", param));
        }
        for (String param : res.getCannotParseArg()) {
            set.add(new SRUDiag("info:srw/diagnostic/1/6", "Unsupported parameter value", param + " : " + params.get(param)));
        }
        for (String param : res.getMissingArgs()) {
            set.add(new SRUDiag("info:srw/diagnostic/1/7", "Mandatory parameter not supplied", param));
        }
        String version = params.get("version");
        if (version != null && !version.equals("1.1") && !version.equals("1.2")) {
            set.add(new SRUDiag("info:srw/diagnostic/1/5", "Unsupported version", "I got version: " + version + " but I support only 1.1 or 1.2"));
        }
        if (!op.equalsIgnoreCase("searchretrieve") && !op.equalsIgnoreCase("explain")) {
            set.add(new SRUDiag("info:srw/diagnostic/1/4", "Unsupported operation", op));
        }
        return set;
    }

    private SearchSessionFactory getSearchSession(ServiceContext context) {
        if (this.searchsessionfact == null) {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            ApplicationContext app_context = gc.getApplicationContext();
            this.searchsessionfact = (SearchSessionFactory)app_context.getBean("SearchSessionFactory");
        }
        return this.searchsessionfact;
    }

    private Hashtable<String, String> parseArgs(List<Element> params) throws MissingParameterEx {
        Hashtable<String, String> res = new Hashtable<String, String>();
        ListIterator<Element> it = params.listIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            String name = e.getName().toLowerCase();
            String val = e.getText().toLowerCase();
            res.put(name, val);
        }
        Hashtable<String, Boolean> opht = new Hashtable<String, Boolean>();
        opht.put(OP, true);
        return res;
    }

    private Element processDiag(Hashtable<String, String> params, String op) throws Exception {
        Set<SRUDiag> diag = this.getDiag(op, params);
        Element diagnostics = null;
        if (diag.size() > 0) {
            diagnostics = new Element("diagnostics");
            for (SRUDiag sruDiag : diag) {
                SRUSearch.addToDiag(diagnostics, sruDiag.getUrl(), sruDiag.getMessage(), sruDiag.getDetails());
            }
        }
        return diagnostics;
    }
}

