/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect.oidclogout;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fao.geonet.kernel.security.openidconnect.oidclogout.OidcSessionInformation;
import org.fao.geonet.kernel.security.openidconnect.oidclogout.OidcSessionRegistry;
import org.fao.geonet.security.web.csrf.GeonetworkCsrfSecurityRequestMatcher;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcBackchannelLogoutFilter
extends OncePerRequestFilter {
    @Autowired
    private OidcSessionRegistry oidcSessionRegistry;
    @Autowired
    private ClientRegistrationRepository clientRegistrationRepository;
    private final RequestMatcher requestMatcher;
    private String sessionCookieName = "JSESSIONID";
    private RestOperations restOperations = new RestTemplate();

    public OidcBackchannelLogoutFilter(CsrfFilter csrfFilter, GeonetworkCsrfSecurityRequestMatcher csrfRequestMatcher) {
        this.requestMatcher = new AntPathRequestMatcher("/**/logout/connect/back-channel/{registrationId}", HttpMethod.POST.name());
        csrfRequestMatcher.addRequestMatcher(new RequestMatcher[]{new NegatedRequestMatcher(this.requestMatcher)});
        csrfFilter.setRequireCsrfProtectionMatcher((RequestMatcher)csrfRequestMatcher);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        RequestMatcher.MatchResult result = this.requestMatcher.matcher(request);
        if (!result.isMatch()) {
            Log.debug((String)"geonetwork.security", (Object)"Request does not match OIDC backchannel logout filter, skipping.");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            String registrationId = (String)result.getVariables().get("registrationId");
            try {
                String logoutToken = request.getParameter("logout_token");
                if (logoutToken == null) {
                    Log.error((String)"geonetwork.security", (Object)"Missing logout_token parameter in request");
                    response.sendError(400, "Missing logout_token");
                    return;
                }
                ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(registrationId);
                if (registrationId == null || clientRegistration == null) {
                    Log.error((String)"geonetwork.security", (Object)("Invalid or missing registrationId: " + registrationId));
                    response.sendError(400, "Invalid or missing registrationId");
                    return;
                }
                if (clientRegistration.getProviderDetails().getJwkSetUri() == null) {
                    Log.error((String)"geonetwork.security", (Object)("JWK Set URI is null for client registration: " + registrationId));
                    response.sendError(400, "Missing JWK Set URI in client registration");
                    return;
                }
                DefaultJOSEObjectTypeVerifier typeVerifier = new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{null, JOSEObjectType.JWT, new JOSEObjectType("logout+jwt")});
                NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)clientRegistration.getProviderDetails().getJwkSetUri()).jwtProcessorCustomizer(arg_0 -> OidcBackchannelLogoutFilter.lambda$doFilterInternal$0((JOSEObjectTypeVerifier)typeVerifier, arg_0)).build();
                jwtDecoder.setClaimSetConverter((Converter)new ClaimTypeConverter(OidcIdTokenDecoderFactory.createDefaultClaimTypeConverters()));
                Jwt jwt = jwtDecoder.decode(logoutToken);
                this.validateLogoutToken(jwt);
                this.logout(request, response, jwt, registrationId);
                response.setStatus(200);
            }
            catch (Exception ex) {
                Log.error((String)"geonetwork.security", (String)("Error processing OIDC Backchannel Logout request: " + ex.getMessage()), (Throwable)ex);
                response.sendError(400, "Invalid logout request: " + ex.getMessage());
            }
        }
    }

    private void validateLogoutToken(Jwt jwt) {
        Map claims = jwt.getClaims();
        if (!claims.containsKey("iss")) {
            throw new JwtException("Logout Token must contain 'iss' claim");
        }
        if (!claims.containsKey("aud")) {
            throw new JwtException("Logout Token must contain 'aud' claim");
        }
        if (!claims.containsKey("iat")) {
            throw new JwtException("Logout Token must contain 'iat' claim");
        }
        if (!claims.containsKey("jti")) {
            throw new JwtException("Logout Token must contain 'jti' claim");
        }
        if (!claims.containsKey("sub") && !claims.containsKey("sid")) {
            throw new JwtException("Logout Token must contain 'sub' or 'sid'");
        }
        if (!claims.containsKey("events")) {
            throw new JwtException("Missing 'events' claim in logout token");
        }
        Map events = (Map)claims.get("events");
        if (!events.containsKey("http://schemas.openid.net/event/backchannel-logout")) {
            throw new JwtException("Invalid 'events' claim value");
        }
        if (claims.containsKey("nonce")) {
            throw new JwtException("Logout Token must not contain 'nonce'");
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Jwt token, String registrationId) throws Exception {
        Log.debug((String)"geonetwork.security", (Object)("Invalidating OIDC sessions for token: " + token.getTokenValue()));
        Iterable<OidcSessionInformation> sessions = this.oidcSessionRegistry.removeSessionInformation(token);
        ArrayList<String> errors = new ArrayList<String>();
        int totalCount = 0;
        int invalidatedCount = 0;
        for (OidcSessionInformation session : sessions) {
            ++totalCount;
            try {
                this.eachLogout(request, token, session, registrationId);
                ++invalidatedCount;
            }
            catch (RestClientException ex) {
                Log.error((String)"geonetwork.security", (String)"Failed to invalidate session", (Throwable)ex);
                errors.add(ex.getMessage());
                this.oidcSessionRegistry.saveSessionInformation(session);
            }
        }
        Log.debug((String)"geonetwork.security", (Object)String.format("Invalidated %d out of %d sessions", invalidatedCount, totalCount));
        if (!errors.isEmpty()) {
            response.setStatus(400);
            Log.error((String)"geonetwork.security", (Object)("Failed to invalidate some sessions: " + String.join((CharSequence)", ", errors)));
            throw new Exception("Failed to invalidate some sessions: " + String.join((CharSequence)", ", errors));
        }
    }

    private void eachLogout(HttpServletRequest request, Jwt token, OidcSessionInformation session, String registrationId) {
        HttpHeaders headers = new HttpHeaders();
        String sessionCookieName = this.sessionCookieName;
        headers.add("Cookie", sessionCookieName + "=" + session.getSessionId());
        for (Map.Entry<String, String> credential : session.getAuthorities().entrySet()) {
            headers.add(credential.getKey(), credential.getValue());
        }
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        String logout = this.computeLogoutEndpoint(request, registrationId);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"logout_token", (Object)token.getTokenValue());
        body.add((Object)"_spring_security_internal_logout", (Object)"true");
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        Log.debug((String)"geonetwork.security", (Object)("Sending internal logout request to: " + logout));
        this.restOperations.postForEntity(logout, (Object)entity, Object.class, new Object[0]);
    }

    String computeLogoutEndpoint(HttpServletRequest request, String registrationId) {
        String protocol = request.getScheme();
        int port = request.getServerPort();
        String host = request.getServerName();
        boolean isDefaultPort = "https".equalsIgnoreCase(protocol) && port == 443 || "http".equalsIgnoreCase(protocol) && port == 80;
        String internalLogoutUri = protocol + "://" + host + (String)(isDefaultPort ? "" : ":" + port) + request.getContextPath() + "/signout";
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery((String)null).fragment((String)null).build();
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme != null ? scheme : "");
        uriVariables.put("baseUrl", uriComponents.toUriString());
        uriVariables.put("baseHost", host != null ? host : "");
        String path = uriComponents.getPath();
        uriVariables.put("basePath", path != null ? path : "");
        uriVariables.put("basePort", port == -1 ? "" : ":" + port);
        uriVariables.put("registrationId", registrationId);
        return UriComponentsBuilder.fromUriString((String)internalLogoutUri).buildAndExpand(uriVariables).toUriString();
    }

    private static /* synthetic */ void lambda$doFilterInternal$0(JOSEObjectTypeVerifier typeVerifier, ConfigurableJWTProcessor processor) {
        processor.setJWSTypeVerifier(typeVerifier);
    }
}

