/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect.bearer;

import java.time.Instant;
import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.user.OAuth2User;

public class UserInfoCacheItem {
    public String accessToken;
    public Instant expireTime;
    public OAuth2User user;
    Collection<? extends GrantedAuthority> authorities;

    public UserInfoCacheItem(String accessToken, Instant expireTime, OAuth2User user, Collection<? extends GrantedAuthority> authorities) {
        this.accessToken = accessToken;
        this.user = user;
        this.expireTime = expireTime;
        this.authorities = authorities;
    }

    public boolean isExpired() {
        return this.expireTime.compareTo(Instant.now()) < 0;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }

    public OAuth2User getUser() {
        return this.user;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }
}

