/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jeeves.component.ProfileManager;
import org.fao.geonet.domain.LDAPUser;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.security.ldap.AbstractLDAPUserDetailsContextMapper;
import org.fao.geonet.utils.Log;

public class LDAPUserDetailsContextMapperWithPattern
extends AbstractLDAPUserDetailsContextMapper {
    private String privilegePattern;
    private Pattern pattern;
    private int groupIndexInPattern;
    private int profilIndexInPattern;

    @Override
    protected void setProfilesAndPrivileges(Profile defaultProfile, String defaultGroup, Map<String, ArrayList<String>> userInfo, LDAPUser userDetails) {
        ArrayList<String> privileges = userInfo.get(((String[])this.mapping.get("privilege"))[0]);
        if (privileges != null) {
            HashSet<Profile> profileList = new HashSet<Profile>();
            for (String privilegeDefinition : privileges) {
                Matcher m = this.pattern.matcher(privilegeDefinition);
                boolean b = m.matches();
                if (b) {
                    String group = m.group(this.groupIndexInPattern);
                    Profile profile = Profile.valueOf((String)m.group(this.profilIndexInPattern));
                    if (profile == null) continue;
                    if (!"ALL".equals(group)) {
                        if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                            Log.debug((String)"geonetwork.ldap", (Object)("  Adding profile " + profile + " for group " + group));
                        }
                        userDetails.addPrivilege(group, profile);
                        profileList.add(profile);
                        continue;
                    }
                    profileList.add(profile);
                    continue;
                }
                Log.error((String)"geonetwork.ldap", (Object)("LDAP privilege info '" + privilegeDefinition + "' does not match search pattern '" + this.privilegePattern + "'. Information ignored."));
            }
            Profile highestUserProfile = ProfileManager.getHighestProfile(profileList.toArray(new Profile[0]));
            if (highestUserProfile != null) {
                if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                    Log.debug((String)"geonetwork.ldap", (Object)("  Highest user profile is " + highestUserProfile));
                }
                userDetails.getUser().setProfile(highestUserProfile);
            }
        }
    }

    public String getPrivilegePattern() {
        return this.privilegePattern;
    }

    public void setPrivilegePattern(String privilegePattern) {
        this.privilegePattern = privilegePattern;
        this.pattern = Pattern.compile(privilegePattern);
    }

    public int getGroupIndexInPattern() {
        return this.groupIndexInPattern;
    }

    public void setGroupIndexInPattern(int groupIndexInPattern) {
        this.groupIndexInPattern = groupIndexInPattern;
    }

    public int getProfilIndexInPattern() {
        return this.profilIndexInPattern;
    }

    public void setProfilIndexInPattern(int profilIndexInPattern) {
        this.profilIndexInPattern = profilIndexInPattern;
    }
}

