/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.keycloak;

import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.kernel.security.SecurityProviderUtil;
import org.fao.geonet.kernel.security.keycloak.KeycloakUserUtils;
import org.fao.geonet.utils.Log;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class KeycloakUtil
implements SecurityProviderUtil {
    public static String signinPath = null;
    private static LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint;
    @Autowired
    private LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint0;
    @Autowired
    private KeycloakUserUtils keycloakUserUtils;

    @PostConstruct
    private void init() {
        loginUrlAuthenticationEntryPoint = this.loginUrlAuthenticationEntryPoint0;
    }

    public static String getSigninPath() {
        if (signinPath == null) {
            try {
                signinPath = loginUrlAuthenticationEntryPoint.getLoginFormUrl().split("\\?")[0];
            }
            catch (BeansException e) {
                Log.debug((String)"geonetwork.security", (Object)"Could not find the bean, using the default instead");
            }
            if (StringUtils.isEmpty((String)signinPath)) {
                signinPath = "/signin";
                Log.warning((String)"geonetwork.security", (Object)"Could not detect signin path from configuration. Using /signin");
            }
        }
        return signinPath;
    }

    @Override
    public String getSSOAuthenticationHeaderValue() {
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof KeycloakPrincipal) {
            RefreshableKeycloakSecurityContext refreshableKeycloakSecurityContext = (RefreshableKeycloakSecurityContext)((KeycloakPrincipal)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getKeycloakSecurityContext();
            return "Bearer " + refreshableKeycloakSecurityContext.getTokenString();
        }
        return null;
    }

    @Override
    public UserDetails getUserDetails(Authentication auth) {
        if (auth != null && auth.getPrincipal() instanceof KeycloakPrincipal) {
            return this.keycloakUserUtils.getUserDetails(((KeycloakPrincipal)auth.getPrincipal()).getKeycloakSecurityContext().getToken(), false);
        }
        return null;
    }

    @Override
    public boolean loginServiceAccount() {
        return false;
    }
}

