/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.keycloak;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.Constants;
import org.fao.geonet.kernel.security.keycloak.KeycloakAuthenticationProcessingFilter;
import org.fao.geonet.kernel.security.keycloak.KeycloakUtil;
import org.fao.geonet.security.web.csrf.GeonetworkCsrfSecurityRequestMatcher;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.keycloak.adapters.springsecurity.filter.KeycloakCsrfRequestMatcher;
import org.keycloak.adapters.springsecurity.filter.KeycloakPreAuthActionsFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.context.ServletContextAware;

public class KeycloakPreAuthActionsLoginFilter
extends KeycloakPreAuthActionsFilter
implements ServletContextAware {
    @Autowired
    LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint;
    private static final String EXCLUDED_URL_PATHS = "excludedPaths";
    private List<AntPathRequestMatcher> excludedPathsMatchers = new ArrayList<AntPathRequestMatcher>();

    public KeycloakPreAuthActionsLoginFilter(UserSessionManagement userSessionManagement) {
        super(userSessionManagement);
    }

    public KeycloakPreAuthActionsLoginFilter(UserSessionManagement userSessionManagement, CsrfFilter csrfFilter, GeonetworkCsrfSecurityRequestMatcher csrfRequestMatcher) {
        super(userSessionManagement);
        csrfRequestMatcher.addRequestMatcher(new RequestMatcher[]{new KeycloakCsrfRequestMatcher()});
        csrfFilter.setRequireCsrfProtectionMatcher((RequestMatcher)csrfRequestMatcher);
    }

    public void setServletContext(ServletContext servletContext) {
        String excludedPathsValue = servletContext.getInitParameter(EXCLUDED_URL_PATHS);
        if (StringUtils.isNotEmpty((CharSequence)excludedPathsValue)) {
            this.excludedPathsMatchers = Arrays.stream(excludedPathsValue.split(",")).map(StringUtils::trimToEmpty).filter(StringUtils::isNotEmpty).map(AntPathRequestMatcher::new).collect(Collectors.toList());
        }
        this.excludedPathsMatchers.add(new AntPathRequestMatcher("/.well-known/jwks.json"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        if (!(servletRequest.getPathInfo() == null || !this.excludedPathsMatchers.stream().noneMatch(matcher -> matcher.matches(servletRequest)) || KeycloakAuthenticationProcessingFilter.DEFAULT_REQUEST_MATCHER.matches(servletRequest) || this.isAuthenticated() || (servletRequest.getContextPath() + KeycloakUtil.getSigninPath()).equals(servletRequest.getRequestURI()) || servletRequest.getRequestURI().endsWith("k_logout") || servletRequest.getRequestURI().endsWith("k_push_not_before") || servletRequest.getRequestURI().endsWith("k_query_bearer_token") || servletRequest.getRequestURI().endsWith("k_test_available") || servletRequest.getRequestURI().endsWith("k_jwks"))) {
            String returningUrl = servletRequest.getRequestURI() + (String)(servletRequest.getQueryString() == null ? "" : "?" + servletRequest.getQueryString());
            String encodedRedirectURL = ((HttpServletResponse)response).encodeRedirectURL(servletRequest.getContextPath() + KeycloakUtil.getSigninPath() + "?redirectUrl=" + URLEncoder.encode(returningUrl, Constants.ENCODING));
            servletResponse.sendRedirect(encodedRedirectURL);
            return;
        }
        super.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse, chain);
    }

    private boolean isAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || AnonymousAuthenticationToken.class.isAssignableFrom(authentication.getClass())) {
            return false;
        }
        return authentication.isAuthenticated();
    }
}

