/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.keyword;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.rdf.QueryBuilder;
import org.fao.geonet.kernel.rdf.Selector;
import org.fao.geonet.kernel.rdf.Selectors;
import org.fao.geonet.kernel.rdf.Where;
import org.fao.geonet.kernel.rdf.Wheres;
import org.fao.geonet.kernel.search.keyword.KeywordLabelSearchClause;
import org.fao.geonet.kernel.search.keyword.KeywordRelation;
import org.fao.geonet.kernel.search.keyword.KeywordSearchParams;
import org.fao.geonet.kernel.search.keyword.KeywordSearchType;
import org.fao.geonet.kernel.search.keyword.RelationShipClause;
import org.fao.geonet.kernel.search.keyword.SearchClause;
import org.fao.geonet.kernel.search.keyword.URISearchClause;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.jdom.Content;
import org.jdom.Element;

public class KeywordSearchParamsBuilder {
    private IsoLanguagesMapper isoLangMapper;
    private Set<String> thesauriNames = new LinkedHashSet<String>();
    private Set<String> langs = new LinkedHashSet<String>();
    private String thesauriDomainName;
    private int offset = -1;
    private int maxResults = -1;
    private LinkedList<SearchClause> searchClauses = new LinkedList();
    private LinkedList<Selector> selectClauses = new LinkedList();
    private boolean lenient;
    private boolean requireBoundedBy = false;
    private Comparator<KeywordBean> comparator;

    public KeywordSearchParamsBuilder(IsoLanguagesMapper mapper) {
        this.isoLangMapper = mapper;
    }

    public static KeywordSearchParamsBuilder createFromElement(IsoLanguagesMapper mapper, Element params) throws BadInputEx {
        String thesauriDomainName;
        String offset;
        String maxResults;
        String uri;
        KeywordSearchParamsBuilder parsedParams = new KeywordSearchParamsBuilder(mapper).lenient(true);
        String keyword = Util.getParam((Element)params, (String)"pKeyword", null);
        if (keyword != null) {
            KeywordSearchType searchType = KeywordSearchType.parseString(Util.getParam((Element)params, (String)"pTypeSearch", (String)KeywordSearchType.MATCH.name()));
            parsedParams.keyword(keyword, searchType, true);
        }
        if ((uri = Util.getParam((Element)params, (String)"pUri", null)) != null) {
            parsedParams.uri(uri);
        }
        if ((maxResults = Util.getParam((Element)params, (String)"maxResults", null)) != null) {
            parsedParams.maxResults(Integer.parseInt(maxResults));
        }
        if ((offset = Util.getParam((Element)params, (String)"offset", null)) != null) {
            parsedParams.offset(Integer.parseInt(offset));
        }
        if ((thesauriDomainName = Util.getParam((Element)params, (String)"pType", null)) != null) {
            parsedParams.thesauriDomainName(thesauriDomainName);
        }
        List thesauri = params.getChildren("pThesauri");
        for (Element thesaurusName : thesauri) {
            String text = thesaurusName.getTextTrim();
            if (text.isEmpty()) continue;
            parsedParams.addThesaurus(text);
        }
        List langs = params.getChildren("pLang");
        for (Element lang : langs) {
            parsedParams.addLang(lang.getTextTrim());
        }
        return parsedParams;
    }

    static void addXmlParam(Element params, String paramName, String value) {
        params.addContent((Content)new Element(paramName).setText(value));
    }

    public KeywordSearchParamsBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        this.checkState(true);
        return this;
    }

    public KeywordSearchParamsBuilder addLang(String lang) {
        this.langs.add(lang);
        this.checkState(true);
        return this;
    }

    public KeywordSearchParamsBuilder addThesaurus(String thesaurusName) {
        this.thesauriNames.add(thesaurusName);
        this.checkState(true);
        return this;
    }

    public Set<String> getThesauriNames() {
        return Collections.unmodifiableSet(this.thesauriNames);
    }

    public KeywordSearchParamsBuilder thesauriDomainName(String thesauriDomainName) {
        this.thesauriDomainName = thesauriDomainName;
        this.checkState(true);
        return this;
    }

    public KeywordSearchParamsBuilder offset(int offset) {
        this.offset = offset;
        this.checkState(true);
        return this;
    }

    public KeywordSearchParamsBuilder maxResults(int maxResults) {
        this.maxResults = maxResults;
        this.checkState(true);
        return this;
    }

    public KeywordSearchParamsBuilder keyword(String keyword, KeywordSearchType searchType, boolean ignoreCase) {
        this.searchClauses.add(new KeywordLabelSearchClause(searchType, keyword, ignoreCase));
        this.checkState(true);
        return this;
    }

    public KeywordSearchParams build() {
        this.checkState(false);
        return new KeywordSearchParams(this.createQuery(), this.thesauriNames, this.thesauriDomainName, this.maxResults, this.comparator);
    }

    private QueryBuilder<KeywordBean> createQuery() {
        Where where = Wheres.NONE;
        if (!this.searchClauses.isEmpty()) {
            for (SearchClause nextClause : this.searchClauses) {
                where = where.or(nextClause.toWhere(this.langs));
            }
        }
        QueryBuilder<KeywordBean> builder = QueryBuilder.keywordQueryBuilder(this.isoLangMapper, new ArrayList<String>(this.langs), this.requireBoundedBy).offset(this.offset).where(where);
        if (!this.selectClauses.isEmpty()) {
            for (Selector s : this.selectClauses) {
                builder.select(s, false);
            }
        }
        return builder;
    }

    private void checkState(boolean errorsOnly) {
        if (!this.lenient && !this.thesauriNames.isEmpty() && this.thesauriDomainName != null) {
            throw new IllegalStateException("thesauriNames and thesauriType cannot both be defined");
        }
        if (!errorsOnly) {
            if (this.langs.isEmpty()) {
                throw new IllegalStateException("At least one language must be defined");
            }
            if (this.offset > 0 && this.thesauriNames.size() != 1) {
                throw new IllegalStateException("Offset can only be used with one thesaurus.  if offest is defined as > 0 then there must be one and only one thesaurus name also defined");
            }
        }
    }

    public Element toXmlParams() {
        Element params = new Element("params");
        KeywordSearchParamsBuilder.addXmlParam(params, "offset", "" + this.offset);
        KeywordSearchParamsBuilder.addXmlParam(params, "maxResults", "" + this.maxResults);
        if (this.thesauriNames.isEmpty()) {
            if (this.thesauriDomainName != null) {
                KeywordSearchParamsBuilder.addXmlParam(params, "pType", this.thesauriDomainName);
            }
        } else {
            for (String name : this.thesauriNames) {
                KeywordSearchParamsBuilder.addXmlParam(params, "pThesauri", name);
            }
        }
        for (String lang : this.langs) {
            KeywordSearchParamsBuilder.addXmlParam(params, "pLang", lang);
        }
        for (SearchClause search : this.searchClauses) {
            search.addXmlParams(params);
        }
        return params;
    }

    public Set<String> getLangs() {
        return Collections.unmodifiableSet(this.langs);
    }

    public KeywordSearchParamsBuilder uri(String keywordURI) {
        this.searchClauses.add(new URISearchClause(keywordURI));
        return this;
    }

    public KeywordSearchParamsBuilder uri(String keywordURI, KeywordSearchType searchType, boolean ignoreCase) {
        this.searchClauses.add(new URISearchClause(searchType, keywordURI, ignoreCase));
        return this;
    }

    public void relationship(String relatedId, KeywordRelation relation, KeywordSearchType searchType, boolean ignoreCase) {
        this.selectClauses.add(Selectors.BROADER);
        this.searchClauses.add(new RelationShipClause(relation, relatedId, searchType, ignoreCase));
    }

    public KeywordSearchParamsBuilder requireBoundedBy(boolean require) {
        this.requireBoundedBy = require;
        return this;
    }

    public KeywordSearchParamsBuilder setComparator(Comparator<KeywordBean> comparator) {
        this.comparator = comparator;
        return this;
    }
}

