/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.oaipmh;

import co.elastic.clients.elasticsearch.core.SearchResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.fao.oaipmh.exceptions.OaiPmhException;
import org.jdom.Content;
import org.jdom.Element;

public class Lib {
    public static final String SESSION_OBJECT = "oai-list-records-result";

    private Lib() {
    }

    public static boolean existsConverter(Path schemaDir, String prefix) {
        Path f = schemaDir.resolve("formatter").resolve(prefix).resolve("view.xsl");
        return Files.exists(f, new LinkOption[0]);
    }

    public static List<String> availableConverters(Path schemaDir) {
        ArrayList<String> result = new ArrayList<String>();
        Path convertDir = schemaDir.resolve("formatter");
        if (Files.exists(convertDir, new LinkOption[0]) && Files.isDirectory(convertDir, new LinkOption[0])) {
            try {
                Files.list(convertDir).forEach(f -> {
                    if (Files.isDirectory(f, new LinkOption[0])) {
                        String folderName = f.getFileName().toString();
                        result.add(folderName);
                    }
                });
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork.oai.provider", (Object)("OAI / Exception while retrieving converters " + e.getMessage()));
            }
        }
        return result;
    }

    public static Element prepareTransformEnv(String uuid, String changeDate, String baseUrl, String siteUrl, String siteName) {
        Element env = new Element("env");
        env.addContent((Content)new Element("uuid").setText(uuid));
        env.addContent((Content)new Element("changeDate").setText(changeDate));
        env.addContent((Content)new Element("baseURL").setText(baseUrl));
        env.addContent((Content)new Element("siteURL").setText(siteUrl));
        env.addContent((Content)new Element("siteName").setText(siteName));
        return env;
    }

    public static Element transform(Path schemaDir, Element env, Element md, String targetFormat) throws Exception {
        Element root = new Element("root");
        root.addContent((Content)md);
        root.addContent((Content)env);
        Path styleSheet = schemaDir.resolve("formatter").resolve(targetFormat).resolve("view.xsl");
        return Xml.transform((Element)root, (Path)styleSheet);
    }

    public static List<Integer> search(ServiceContext context, Element params) throws Exception {
        EsSearchManager searchMan = context.getBean(EsSearchManager.class);
        JsonNode esJsonQuery = Lib.createSearchQuery(params);
        SearchResponse queryResult = searchMan.query(esJsonQuery, EsSearchManager.FIELDLIST_CORE, 0, 1);
        long total = queryResult.hits().total().value();
        queryResult = searchMan.query(esJsonQuery, EsSearchManager.FIELDLIST_CORE, 0, (int)total);
        ObjectMapper objectMapper = new ObjectMapper();
        List<Integer> result = queryResult.hits().hits().stream().map(h -> Integer.parseInt(((Map)objectMapper.convertValue(h.source(), Map.class)).get("id").toString())).collect(Collectors.toList());
        return result;
    }

    public static Element toJeevesException(OaiPmhException e) {
        String msg = e.getMessage();
        String cls = e.getClass().getSimpleName();
        String id = e.getCode();
        Element res = e.getResponse();
        Element error = new Element("error").addContent((Content)new Element("message").setText(msg)).addContent((Content)new Element("class").setText(cls));
        error.setAttribute("id", id);
        if (res != null) {
            Element elObj = new Element("object");
            elObj.addContent(res.detach());
            error.addContent((Content)elObj);
        }
        return error;
    }

    static JsonNode createSearchQuery(Element params) throws JsonProcessingException {
        String PARAM_SET = "category";
        String PARAM_FROM = "extFrom";
        String PARAM_UNTIL = "extTo";
        String PARAM_METADATAPREFIX = "_schema";
        String jsonQuery = "{    \"bool\": {      \"must\": [        {          \"terms\": {            \"isTemplate\": [\"n\"]          }        }%s%s      ]    }}";
        String categoryQuery = "";
        if (params.getChild("category") != null) {
            categoryQuery = String.format("        ,{          \"term\": {            \"cat\": {              \"value\": \"%s\"            }          }        }", params.getChild("category").getValue());
        }
        String temporalExtentQuery = "";
        if (params.getChild("extFrom") != null || params.getChild("extTo") != null) {
            String fromQuery = "";
            if (params.getChild("extFrom") != null) {
                fromQuery = String.format("                \"gte\": \"%s\",", params.getChild("extFrom").getValue());
            }
            String untilQuery = "";
            if (params.getChild("extTo") != null) {
                untilQuery = String.format("                \"lte\": \"%s\",", params.getChild("extTo").getValue());
            }
            temporalExtentQuery = String.format("  ,{\"range\": {\"resourceTemporalDateRange\": {                %s                %s                \"relation\": \"intersects\"            }}}", fromQuery, untilQuery);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readTree(String.format(jsonQuery, categoryQuery, temporalExtentQuery));
    }
}

