/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.UrlEscapers;
import org.fao.geonet.domain.MetadataResourceContainer;
import org.fao.geonet.domain.MetadataResourceExternalManagementProperties;

public class FilesystemStoreResourceContainer
implements MetadataResourceContainer {
    private final String url;
    private final int metadataId;
    private final String metadataUuid;
    private final String containerName;
    private final MetadataResourceExternalManagementProperties metadataResourceExternalManagementProperties;
    private final boolean approved;

    public FilesystemStoreResourceContainer(String metadataUuid, int metadataId, String containerName, String baseUrl, MetadataResourceExternalManagementProperties metadataResourceExternalManagementProperties, boolean approved) {
        this.metadataUuid = metadataUuid;
        this.metadataId = metadataId;
        this.approved = approved;
        this.containerName = containerName;
        this.url = baseUrl + this.getId();
        this.metadataResourceExternalManagementProperties = metadataResourceExternalManagementProperties;
    }

    public FilesystemStoreResourceContainer(String metadataUuid, int metadataId, String containerName, String baseUrl, boolean approved) {
        this(metadataUuid, metadataId, containerName, baseUrl, null, approved);
    }

    public String getId() {
        return UrlEscapers.urlFragmentEscaper().escape(this.metadataUuid) + "/attachments/";
    }

    public String getUrl() {
        return this.url;
    }

    public String getContainterName() {
        return this.containerName;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public int getMetadataId() {
        return this.metadataId;
    }

    public String getMetadataUuid() {
        return this.metadataUuid;
    }

    public MetadataResourceExternalManagementProperties getMetadataResourceExternalManagementProperties() {
        return this.metadataResourceExternalManagementProperties;
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error converting FilesystemStoreResourceContainer to json", e);
        }
    }
}

