/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.Log;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSink;
import org.globus.ftp.FTPClient;
import org.jdom.Element;
import org.springframework.core.io.Resource;

public final class BinaryFile {
    private static final int BUF_SIZE = 8192;
    private Element element = new Element("response");
    private boolean remoteFile = false;
    private String remoteUser = "";
    private String remotePassword = "";
    private String remoteSite = "";
    private String remotePath = "";
    private String remoteProtocol = "";

    public BinaryFile() {
    }

    public BinaryFile(Element element) {
        this.element = element;
    }

    public static BinaryFile encode(int responseCode, Path path, String name, boolean remove) {
        BinaryFile response = BinaryFile.encode(responseCode, path, remove);
        response.getElement().setAttribute("name", name);
        return response;
    }

    public static BinaryFile encode(int responseCode, Path path) {
        return BinaryFile.encode(responseCode, path, false);
    }

    public static BinaryFile encode(int responseCode, Path path, boolean remove) {
        BinaryFile binaryFile = new BinaryFile();
        binaryFile.doEncode(responseCode, path, remove);
        return binaryFile;
    }

    public static BinaryFile encode(int responseCode, Resource resource, int metadataId, String filename, boolean remove) throws IOException {
        Path path;
        if (resource.isFile()) {
            path = resource.getFile().toPath();
        } else {
            Path tempFolderPath = Files.createTempDirectory("gn-meta-res-" + metadataId + "-", new FileAttribute[0]);
            tempFolderPath.toFile().deleteOnExit();
            path = tempFolderPath.resolve(filename);
            try (InputStream in = resource.getInputStream();){
                Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return BinaryFile.encode(responseCode, path, remove);
    }

    private static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                Log.error("jeeves.resources", "scp: Protocol error: " + sb.toString());
            }
            if (b == 2) {
                Log.error("jeeves.resources", "scp: Protocol error: " + sb.toString());
            }
        }
        return b;
    }

    private static void copy(InputStream inScp, OutputStream outScp, OutputStream output) throws IOException {
        int c;
        byte[] buf = new byte[1024];
        buf[0] = 0;
        outScp.write(buf, 0, 1);
        outScp.flush();
        while ((c = BinaryFile.checkAck(inScp)) == 67) {
            int foo;
            if (inScp.read(buf, 0, 5) == -1) {
                throw new IllegalStateException("Expected 0664 but got nothing");
            }
            long filesize = 0L;
            while (inScp.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                filesize = filesize * 10L + (long)(buf[0] - 48);
            }
            String file = null;
            int i = 0;
            while (true) {
                if (inScp.read(buf, i, 1) == -1) {
                    throw new IllegalStateException("Unable to read file name");
                }
                if (buf[i] == 10) break;
                ++i;
            }
            file = new String(buf, 0, i, Charset.forName(Constants.ENCODING));
            if (Log.isDebugEnabled("jeeves.resources")) {
                Log.debug("jeeves.resources", "scp: file returned has filesize=" + filesize + ", file=" + file);
            }
            buf[0] = 0;
            outScp.write(buf, 0, 1);
            outScp.flush();
            do {
                foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                if ((foo = inScp.read(buf, 0, foo)) < 0) break;
                output.write(buf, 0, foo);
            } while ((filesize -= (long)foo) != 0L);
            if (BinaryFile.checkAck(inScp) != 0) continue;
            buf[0] = 0;
            outScp.write(buf, 0, 1);
            outScp.flush();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        if (in instanceof FileInputStream) {
            FileInputStream fin = (FileInputStream)in;
            WritableByteChannel outChannel = out instanceof FileOutputStream ? ((FileOutputStream)out).getChannel() : Channels.newChannel(out);
            fin.getChannel().transferTo(0L, Long.MAX_VALUE, outChannel);
        } else {
            int nRead;
            BufferedInputStream input = new BufferedInputStream(in);
            byte[] buffer = new byte[8192];
            while ((nRead = input.read(buffer)) > 0) {
                out.write(buffer, 0, nRead);
            }
        }
    }

    private static String getContentType(String fName) {
        if (fName.endsWith(".gif")) {
            return "image/gif";
        }
        if (fName.endsWith(".jpg") || fName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (fName.endsWith(".png")) {
            return "application/png";
        }
        if (fName.endsWith(".bmp")) {
            return "application/bmp";
        }
        if (fName.endsWith(".zip")) {
            return "application/zip";
        }
        if (fName.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (fName.endsWith(".eps")) {
            return "application/eps";
        }
        if (fName.endsWith(".ai")) {
            return "application/ai";
        }
        if (fName.endsWith(".pmf")) {
            return "application/pmf";
        }
        if (fName.endsWith(".e00")) {
            return "application/e00";
        }
        return "application/binary";
    }

    private String getRemotePassword() {
        return this.remotePassword;
    }

    private String readInput(Path path) {
        try {
            return new String(Files.readAllBytes(path), Constants.CHARSET);
        }
        catch (IOException e) {
            Log.error("geonetwork", "Error reading file: " + path);
            return null;
        }
    }

    private String getRemoteProtocol(String header) {
        String remoteProtocol = header.startsWith("#geonetworkremotescp") ? "scp" : (header.startsWith("#geonetworkremoteftp") ? "ftp" : "unknown");
        return remoteProtocol;
    }

    private void checkForRemoteFile(Path path) {
        String fileContents = this.readInput(path);
        if (fileContents != null && (fileContents.toLowerCase().startsWith("#geonetworkremotescp") || fileContents.toLowerCase().startsWith("#geonetworkremoteftp"))) {
            String[] tokens = fileContents.split("\n");
            if (tokens.length == 5) {
                this.remoteUser = tokens[1].trim();
                this.remotePassword = tokens[2].trim();
                this.remoteSite = tokens[3].trim();
                this.remotePath = tokens[4].trim();
                this.remoteProtocol = this.getRemoteProtocol(fileContents.toLowerCase());
                this.remoteFile = true;
                if (Log.isDebugEnabled("jeeves.resources")) {
                    Log.debug("jeeves.resources", "REMOTE: " + this.remoteUser + ":********:" + this.remoteSite + ":" + this.remotePath + ":" + this.remoteProtocol);
                }
            } else {
                if (Log.isDebugEnabled("jeeves.resources")) {
                    Log.debug("jeeves.resources", "ERROR: remote file details were not valid");
                }
                this.remoteFile = false;
            }
        } else {
            this.remoteFile = false;
        }
    }

    private void doEncode(int responseCode, Path path, boolean remove) {
        this.checkForRemoteFile(path);
        this.element.setAttribute("responseCode", "" + responseCode);
        this.element.setAttribute("path", path.toString());
        this.element.setAttribute("remove", remove ? "y" : "n");
        if (this.remoteFile) {
            this.element.setAttribute("remotepath", this.remoteUser + "@" + this.remoteSite + ":" + this.remotePath);
            this.element.setAttribute("remotefile", new File(this.remotePath).getName());
        }
    }

    public String getContentType() {
        String path = this.element.getAttributeValue("path");
        if (path == null) {
            return null;
        }
        return BinaryFile.getContentType(path);
    }

    public String getContentLength() {
        String path = this.element.getAttributeValue("path");
        if (path == null) {
            return null;
        }
        Object length = "-1";
        if (!this.remoteFile) {
            File f = new File(path);
            length = "" + f.length();
        }
        return length;
    }

    public void removeIfTheCase() {
        String path;
        File file;
        boolean remove = "y".equals(this.element.getAttributeValue("remove"));
        if (remove && !(file = new File(path = this.element.getAttributeValue("path"))).delete() && file.exists()) {
            Log.warning("jeeves", "[" + BinaryFile.class.getName() + "#removeIfTheCase]Unable to remove binary file after sending to user.");
        }
    }

    public String getContentDisposition() {
        String name = this.element.getAttributeValue("name");
        if (name == null) {
            name = this.element.getAttributeValue("path");
            if (name == null) {
                return null;
            }
            name = new File(name).getName();
        }
        return StringEscapeUtils.escapeHtml((String)("attachment;filename=" + name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream output) throws IOException {
        block14: {
            block15: {
                String path = this.element.getAttributeValue("path");
                if (path == null) {
                    return;
                }
                if (this.remoteFile) break block15;
                File f = new File(path);
                FileInputStream input = null;
                try {
                    input = new FileInputStream(f);
                    BinaryFile.copy(input, output);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
                break block14;
            }
            if (this.remoteProtocol.equals("scp")) {
                try {
                    JSch jsch = new JSch();
                    Session session = jsch.getSession(this.remoteUser, this.remoteSite, 22);
                    class MyUserInfo
                    implements UserInfo {
                        String passwd;

                        MyUserInfo() {
                            this.passwd = BinaryFile.this.getRemotePassword();
                        }

                        public String getPassword() {
                            return this.passwd;
                        }

                        public String getPassphrase() {
                            return this.passwd;
                        }

                        public void showMessage(String message) {
                        }

                        public boolean promptYesNo(String message) {
                            return true;
                        }

                        public boolean promptPassword(String message) {
                            return true;
                        }

                        public boolean promptPassphrase(String message) {
                            return true;
                        }
                    }
                    MyUserInfo ui = new MyUserInfo();
                    session.setUserInfo((UserInfo)ui);
                    try {
                        session.connect();
                        String command = "scp -f " + this.remotePath;
                        Channel channel = session.openChannel("exec");
                        ((ChannelExec)channel).setCommand(command);
                        OutputStream outScp = channel.getOutputStream();
                        InputStream inScp = channel.getInputStream();
                        channel.connect();
                        BinaryFile.copy(inScp, outScp, output);
                    }
                    finally {
                        session.disconnect();
                    }
                }
                catch (Exception e) {
                    Log.error("jeeves.resources", "Problem with scp from site: " + this.remoteUser + "@" + this.remoteSite + ":" + this.remotePath, (Throwable)e);
                }
            } else if (this.remoteProtocol.equals("ftp")) {
                try {
                    FTPClient ftp = new FTPClient(this.remoteSite, 21);
                    ftp.authorize(this.remoteUser, this.remotePassword);
                    ftp.setType(1);
                    class DataSinkStream
                    implements DataSink {
                        protected OutputStream out;
                        protected boolean autoFlush;
                        protected boolean ignoreOffset;
                        protected long offset = 0L;

                        public DataSinkStream(OutputStream out) {
                            this(out, false, false);
                        }

                        public DataSinkStream(OutputStream out, boolean autoFlush, boolean ignoreOffset) {
                            this.out = out;
                            this.autoFlush = autoFlush;
                            this.ignoreOffset = ignoreOffset;
                        }

                        public void write(Buffer buffer) throws IOException {
                            long bufOffset = buffer.getOffset();
                            if (this.ignoreOffset || bufOffset == -1L || bufOffset == this.offset) {
                                this.out.write(buffer.getBuffer(), 0, buffer.getLength());
                                if (this.autoFlush) {
                                    this.out.flush();
                                }
                                this.offset += (long)buffer.getLength();
                            } else {
                                throw new IOException("Random offsets not supported.");
                            }
                        }

                        public void close() {
                        }
                    }
                    DataSinkStream outputSink = new DataSinkStream(output);
                    ftp.get(this.remotePath, (DataSink)outputSink, null);
                }
                catch (Exception e) {
                    Log.error("jeeves.resources", "Problem with ftp from site: " + this.remoteUser + "@" + this.remoteSite + ":" + this.remotePath, (Throwable)e);
                }
            } else {
                Log.error("jeeves.resources", "Unknown remote protocol in config file");
            }
        }
    }

    public Element getElement() {
        return this.element;
    }
}

