/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.jdom.Element;

public final class Util {
    private Util() {
    }

    public static Element getChild(Element el, String name) throws MissingParameterEx {
        Element param = el.getChild(name);
        if (param == null) {
            throw new MissingParameterEx(name, el);
        }
        return param;
    }

    public static String getParam(Element el, String name) throws BadInputEx {
        if (el == null) {
            throw new MissingParameterEx(name);
        }
        Element param = el.getChild(name);
        if (param == null) {
            throw new MissingParameterEx(name, el);
        }
        String value = param.getTextTrim();
        if (value.isEmpty()) {
            throw new BadParameterEx(name, value);
        }
        return value;
    }

    public static List<String> getParams(Element el, String name) throws BadInputEx {
        if (el == null) {
            throw new MissingParameterEx(name);
        }
        LinkedList<String> values = new LinkedList<String>();
        for (Object obj : el.getChildren(name)) {
            Element param = (Element)obj;
            String value = param.getTextTrim();
            if (value.isEmpty()) {
                throw new BadParameterEx(name, value);
            }
            values.add(value);
        }
        return values;
    }

    public static String getParam(Element el, String name, String defValue) {
        if (el == null) {
            return defValue;
        }
        Element param = el.getChild(name);
        if (param == null) {
            return defValue;
        }
        String value = param.getTextTrim();
        if (value.isEmpty()) {
            return defValue;
        }
        return value;
    }

    public static int getParamAsInt(Element el, String name) throws BadInputEx {
        String value = Util.getParam(el, name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new BadParameterEx(name, value);
        }
    }

    public static List<Integer> getParamsAsInt(Element el, String name) throws BadInputEx {
        LinkedList<Integer> values = new LinkedList<Integer>();
        for (String value : Util.getParams(el, name)) {
            try {
                values.add(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new BadParameterEx(name, value);
            }
        }
        return values;
    }

    public static int getParam(Element el, String name, int defValue) throws BadParameterEx {
        String value = Util.getParam(el, name, null);
        if (value == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new BadParameterEx(name, value);
        }
    }

    public static boolean getParam(Element el, String name, boolean defValue) throws BadParameterEx {
        String value = Util.getParam(el, name, null);
        if (value == null) {
            return defValue;
        }
        if ((value = value.toLowerCase()).equals("true") || value.equals("on") || value.equals("yes")) {
            return true;
        }
        if (value.equals("false") || value.equals("off") || value.equals("no")) {
            return false;
        }
        throw new BadParameterEx(name, value);
    }

    public static String getAttrib(Element el, String name) throws BadInputEx {
        String value = el.getAttributeValue(name);
        if (value == null) {
            throw new MissingParameterEx("attribute:" + name, el);
        }
        if ((value = value.trim()).isEmpty()) {
            throw new BadParameterEx("attribute:" + name, value);
        }
        return value;
    }

    public static String getAttrib(Element el, String name, String defValue) {
        if (el == null) {
            return defValue;
        }
        String value = el.getAttributeValue(name);
        if (StringUtils.isBlank((String)value)) {
            return defValue;
        }
        return value.trim();
    }

    public static String getHeader(Map<String, String> headers, String name, String defValue) {
        if (headers == null) {
            return defValue;
        }
        String value = headers.get(name);
        return StringUtils.defaultIfBlank((String)value, (String)defValue);
    }

    public static String replaceString(String original, String pattern, String replacement) {
        return StringUtils.replace((String)original, (String)pattern, (String)replacement);
    }

    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String getParamText(Element params, String desired) {
        String value = Util.getParam(params, desired, "");
        if (value.isEmpty()) {
            return null;
        }
        return value;
    }

    public static void toLowerCase(Element params) {
        for (Object o : params.getChildren()) {
            if (!(o instanceof Element)) continue;
            Element element = (Element)o;
            element.setName(element.getName().toLowerCase());
        }
    }
}

