/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.dlib.gui.CustomLook;

public class TToggleButton
extends JToggleButton {
    private boolean bInside = false;

    public TToggleButton(String string, String string2, ActionListener actionListener) {
        super(string);
        this.setActionCommand(string2);
        this.addActionListener(actionListener);
        this.setPreferredSize(CustomLook.buttonSize);
        this.setBackground(CustomLook.buttonColor);
        this.setFont(CustomLook.buttonFont);
    }

    public TToggleButton(ImageIcon imageIcon, String string, ActionListener actionListener, String string2) {
        super(imageIcon);
        this.setActionCommand(string);
        this.addActionListener(actionListener);
        this.addMouseListener(new TListener());
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setToolTipText(string2);
        this.setPreferredSize(CustomLook.buttonSmallSize);
        this.setMinimumSize(CustomLook.buttonSmallSize);
        this.setMaximumSize(CustomLook.buttonSmallSize);
    }

    public void paintComponent(Graphics graphics) {
        CustomLook.setup(graphics);
        super.paintComponent(graphics);
        if (this.bInside && this.isEnabled()) {
            Color color = Color.white;
            Color color2 = Color.gray;
            if (this.isSelected()) {
                Color color3 = color;
                color = color2;
                color2 = color3;
            }
            int n = this.getWidth() - 1;
            int n2 = this.getHeight() - 1;
            graphics.setColor(color);
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, 0, n2);
            graphics.setColor(color2);
            graphics.drawLine(0, n2, n, n2);
            graphics.drawLine(n, n2, n, 0);
        }
    }

    private class TListener
    extends MouseAdapter {
        private TListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            TToggleButton.this.bInside = true;
            TToggleButton.this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            TToggleButton.this.bInside = false;
            TToggleButton.this.repaint();
        }
    }
}

