/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.dlib.gui.TCheckBoxMenuItem;
import org.dlib.gui.TMenu;
import org.dlib.gui.TMenuItem;
import org.dlib.gui.TRadioButtonMenuItem;
import org.dlib.xml.XmlElement;
import org.dlib.xml.reader.XmlReader;

public class MenuBuilder {
    private static final String ATTR_FONT = "font";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_KEY_ALT = "alt";
    private static final String ATTR_KEY_CTRL = "ctrl";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_TYPE_ITEM = "item";
    private static final String ATTR_TYPE_MENU = "menu";
    private static final String ATTR_TYPE_CHECK = "check";
    private static final String ATTR_TYPE_RADIO = "radio";
    private static final String SEPARATOR = "separator";
    private ActionListener al;
    private JMenu jMenu;
    private Hashtable htItems = new Hashtable();

    public MenuBuilder() {
    }

    public MenuBuilder(String string, ActionListener actionListener) {
        this.al = actionListener;
        this.setXmlFile(string);
    }

    public void setActionListener(ActionListener actionListener) {
        this.al = actionListener;
    }

    public void setXmlFile(String string) {
        try {
            XmlElement xmlElement = new XmlReader().read(string).getRootElement();
            this.jMenu = (JMenu)this.buildItems(xmlElement, null, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JMenuBar getMenuBar() {
        int n;
        JMenuBar jMenuBar = new JMenuBar();
        Vector<Component> vector = new Vector<Component>();
        for (n = 0; n < this.jMenu.getItemCount(); ++n) {
            JMenuItem jMenuItem = this.jMenu.getItem(n);
            if (jMenuItem == null) {
                vector.add(Box.createHorizontalGlue());
                continue;
            }
            vector.add(jMenuItem);
        }
        for (n = 0; n < vector.size(); ++n) {
            jMenuBar.add((Component)vector.get(n));
        }
        return jMenuBar;
    }

    public JPopupMenu getPopupMenu() {
        return this.jMenu.getPopupMenu();
    }

    public JMenu getMenu(String string) {
        return (JMenu)this.htItems.get(string);
    }

    public JMenuItem getMenuItem(String string) {
        return (JMenuItem)this.htItems.get(string);
    }

    private JMenuItem buildItems(XmlElement xmlElement, JMenu jMenu, boolean bl) {
        List list;
        String string = xmlElement.getName();
        String string2 = xmlElement.getAttributeValue(ATTR_LABEL);
        String string3 = xmlElement.getAttributeValue(ATTR_TYPE);
        Font font = this.handleFont(xmlElement);
        KeyStroke keyStroke = this.handleKey(xmlElement);
        if (string3 == null) {
            string3 = ATTR_TYPE_ITEM;
        }
        if ((list = xmlElement.getChildren()).size() == 0 && !string3.equals(ATTR_TYPE_MENU) && !bl) {
            JMenuItem jMenuItem;
            if (string3.equals(ATTR_TYPE_ITEM)) {
                jMenuItem = new TMenuItem(string2);
            } else if (string3.equals(ATTR_TYPE_CHECK)) {
                jMenuItem = new TCheckBoxMenuItem(string2);
            } else if (string3.equals(ATTR_TYPE_RADIO)) {
                jMenuItem = new TRadioButtonMenuItem(string2);
            } else {
                throw new IllegalArgumentException("Unknown menu-item type --> " + string3);
            }
            jMenuItem.setActionCommand(string);
            if (font != null) {
                jMenuItem.setFont(font);
            } else if (jMenu != null) {
                jMenuItem.setFont(jMenu.getFont());
            }
            if (this.al != null) {
                jMenuItem.addActionListener(this.al);
            }
            if (keyStroke != null) {
                jMenuItem.setAccelerator(keyStroke);
            }
            this.htItems.put(string, jMenuItem);
            return jMenuItem;
        }
        TMenu tMenu = new TMenu(string2);
        if (font != null) {
            tMenu.setFont(font);
        } else if (jMenu != null) {
            tMenu.setFont(jMenu.getFont());
        }
        for (int i = 0; i < list.size(); ++i) {
            XmlElement xmlElement2 = (XmlElement)list.get(i);
            if (xmlElement2.getName().equals(SEPARATOR)) {
                tMenu.addSeparator();
                continue;
            }
            tMenu.add(this.buildItems(xmlElement2, tMenu, false));
        }
        this.htItems.put(string, tMenu);
        return tMenu;
    }

    private Font handleFont(XmlElement xmlElement) {
        String string = xmlElement.getAttributeValue(ATTR_FONT);
        if (string == null) {
            return null;
        }
        int n = 12;
        int n2 = string.indexOf("/");
        if (n2 != -1) {
            n = Integer.parseInt(string.substring(n2 + 1));
            string = string.substring(0, n2);
        }
        return new Font(string, 0, n);
    }

    private KeyStroke handleKey(XmlElement xmlElement) {
        String string = xmlElement.getAttributeValue(ATTR_KEY);
        if (string == null) {
            return null;
        }
        int n = string.indexOf("-");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n2 = 0;
        if (string2.equals(ATTR_KEY_ALT)) {
            n2 = 8;
        }
        if (string2.equals(ATTR_KEY_CTRL)) {
            n2 = 2;
        }
        return KeyStroke.getKeyStroke(65 + string3.charAt(0) - 97, n2);
    }
}

