/*
 * Decompiled with CFR 0.152.
 */
package v300;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.fao.geonet.DatabaseMigrationTask;
import org.fao.geonet.utils.Log;

public class SetSequenceValueToMaxOfMetadataAndStats
extends DatabaseMigrationTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Connection connection) throws SQLException {
        Log.debug((String)"geonetwork.database", (Object)"SetSequenceValueToMaxOfMetadataAndStats");
        try (Statement statement = connection.createStatement();){
            String numberOfMetadataSQL = "SELECT max(id) as NB FROM Metadata";
            String numberOfParamsSQL = "SELECT max(id) as NB FROM Params";
            String numberOfRequestsSQL = "SELECT max(id) as NB FROM Requests";
            int numberOfMetadata = 0;
            try (ResultSet metadataResultSet = statement.executeQuery("SELECT max(id) as NB FROM Metadata");){
                if (metadataResultSet.next()) {
                    numberOfMetadata = metadataResultSet.getInt(1);
                }
                Log.debug((String)"geonetwork.database", (Object)("  Number of metadata: " + numberOfMetadata));
            }
            int numberOfParams = 0;
            try (ResultSet paramsResultSet = statement.executeQuery("SELECT max(id) as NB FROM Params");){
                if (paramsResultSet.next()) {
                    numberOfParams = paramsResultSet.getInt(1);
                }
                Log.debug((String)"geonetwork.database", (Object)("  Number of params (statistics): " + numberOfParams));
            }
            int numberOfRequests = 0;
            try (ResultSet requestsResultSet = statement.executeQuery("SELECT max(id) as NB FROM Requests");){
                if (requestsResultSet.next()) {
                    numberOfRequests = requestsResultSet.getInt(1);
                }
                Log.debug((String)"geonetwork.database", (Object)("  Number of requests (statistics): " + numberOfRequests));
            }
            try {
                int newSequenceValue = Math.max(numberOfMetadata, Math.max(numberOfParams, numberOfRequests)) + 1;
                Log.debug((String)"geonetwork.database", (Object)("  Set sequence to value: " + newSequenceValue));
                String updateSequenceSQL = "ALTER SEQUENCE HIBERNATE_SEQUENCE RESTART WITH " + newSequenceValue;
                statement.execute(updateSequenceSQL);
                Log.debug((String)"geonetwork.database", (Object)"  Sequence updated.");
            }
            catch (Exception e) {
                Log.debug((String)"geonetwork.database", (Object)("  Sequence not updated. Error is: " + e.getMessage()));
                Log.error((String)"geonetwork.database", (Object)e);
            }
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.database", (Object)("  Exception while updating sequence. Error is: " + e.getMessage()));
            Log.error((String)"geonetwork.database", (Object)e);
        }
    }
}

