/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.color;

import java.awt.Color;
import org.geotools.brewer.color.ColorPalette;
import org.geotools.brewer.color.PaletteSuitability;
import org.geotools.brewer.color.PaletteType;
import org.geotools.brewer.color.SampleScheme;

public class BrewerPalette
extends ColorPalette {
    private PaletteSuitability suitability;
    private SampleScheme sampler;
    private PaletteType type;

    public PaletteType getType() {
        return this.type;
    }

    public void setType(PaletteType type) {
        this.type = type;
    }

    public Color getColor(int index, int length) {
        return this.getColors(length)[index];
    }

    public int getMaxColors() {
        int numColors;
        int countSampler = this.sampler.getMaxCount();
        if (countSampler < (numColors = this.getCount())) {
            return countSampler;
        }
        return numColors;
    }

    public int getMinColors() {
        return this.sampler.getMinCount();
    }

    @Override
    public Color[] getColors(int length) {
        if (length < 2) {
            length = 2;
        }
        int[] lookup = this.sampler.getSampleScheme(length);
        Color[] colors = this.getColors();
        Color[] result = new Color[length];
        for (int i = 0; i < length; ++i) {
            result[i] = colors[lookup[i]];
        }
        return result;
    }

    public PaletteSuitability getPaletteSuitability() {
        return this.suitability;
    }

    public void setPaletteSuitability(PaletteSuitability suitability) {
        this.suitability = suitability;
    }

    public SampleScheme getColorScheme() {
        return this.sampler;
    }

    public void setColorScheme(SampleScheme scheme) {
        this.sampler = scheme;
    }
}

