/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v1_x;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import net.opengis.wfs.GetFeatureType;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.v1_x.StrictWFS_1_x_Strategy;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.xsd.Encoder;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class CubeWerxStrategy
extends StrictWFS_1_x_Strategy {
    @Override
    public boolean supports(GetFeatureRequest.ResultType resultType) {
        return GetFeatureRequest.ResultType.RESULTS.equals((Object)resultType);
    }

    @Override
    protected Map<String, String> buildGetFeatureParametersForGET(GetFeatureRequest request) {
        Map<String, String> params = super.buildGetFeatureParametersForGET(request);
        params.remove("RESULTTYPE");
        return params;
    }

    @Override
    public InputStream getPostContents(WFSRequest request) throws IOException {
        Document dom;
        if (!(request instanceof GetFeatureRequest)) {
            return super.getPostContents(request);
        }
        GetFeatureType requestObject = this.createGetFeatureRequestPost((GetFeatureRequest)request);
        Encoder encoder = this.prepareEncoder(request);
        QName opName = this.getOperationName(request.getOperation());
        try {
            dom = encoder.encodeAsDOM((Object)requestObject, opName);
        }
        catch (TransformerException | SAXException e) {
            throw new IOException(e);
        }
        dom.getDocumentElement().removeAttribute("resultType");
        DOMImplementationLS domImpl = (DOMImplementationLS)((Object)dom.getImplementation());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LSOutput destination = domImpl.createLSOutput();
        destination.setByteStream(out);
        LSSerializer serializer = domImpl.createLSSerializer();
        DOMConfiguration domConfig = serializer.getDomConfig();
        if (domConfig.canSetParameter("format-pretty-print", Boolean.TRUE)) {
            domConfig.setParameter("format-pretty-print", Boolean.TRUE);
        }
        serializer.write(dom, destination);
        Loggers.requestTrace(new Object[]{"Encoded ", request.getOperation(), " request: ", out});
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public Filter[] splitFilters(QName typeName, Filter queryFilter) {
        Filter[] splitFilters = super.splitFilters(typeName, queryFilter);
        Filter serverFilter = splitFilters[0];
        if (!(serverFilter instanceof BinaryLogicOperator)) {
            return splitFilters;
        }
        Filter postFilter = queryFilter;
        if (serverFilter instanceof Or) {
            serverFilter = Filter.INCLUDE;
        } else {
            boolean spatialAdded = false;
            ArrayList children = new ArrayList(((BinaryLogicOperator)serverFilter).getChildren());
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Filter f = (Filter)it.next();
                if (!(f instanceof BinarySpatialOperator)) continue;
                if (spatialAdded) {
                    it.remove();
                    continue;
                }
                spatialAdded = true;
            }
            FilterFactory ff = CommonFactoryFinder.getFilterFactory();
            serverFilter = ff.and(children);
            SimplifyingFilterVisitor sfv = new SimplifyingFilterVisitor();
            serverFilter = (Filter)serverFilter.accept((FilterVisitor)sfv, null);
        }
        return new Filter[]{serverFilter, postFilter};
    }
}

