/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs20.StoredQueryDescriptionType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.http.HTTPClient;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class GetFeatureRequest
extends WFSRequest {
    private static Logger LOGGER = Logging.getLogger(GetFeatureRequest.class);
    private String[] propertyNames;
    private String srsName;
    private Filter filter;
    private Integer maxFeatures;
    private Integer startIndex;
    private ResultType resultType = ResultType.RESULTS;
    private SortBy[] sortBy;
    private FeatureType fullType;
    private FeatureType queryType;
    private Filter unsupportedFilter;
    private boolean storedQuery;
    private StoredQueryDescriptionType storedQueryDescriptionType;
    private Hints hints;
    private final HTTPClient httpClient;

    GetFeatureRequest(WFSConfig config, WFSStrategy strategy) {
        this(config, strategy, null);
    }

    GetFeatureRequest(WFSConfig config, WFSStrategy strategy, HTTPClient httpClient) {
        super(WFSOperationType.GET_FEATURE, config, strategy);
        this.httpClient = httpClient;
    }

    public HTTPClient getHTTPClient() {
        return this.httpClient;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public String getSrsName() {
        return this.srsName;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Integer getMaxFeatures() {
        return this.maxFeatures;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public SortBy[] getSortBy() {
        return this.sortBy;
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }

    public void findSupportedSrsName(CoordinateReferenceSystem crs) {
        String identifier = GML2EncodingUtils.toURI((CoordinateReferenceSystem)crs, (SrsSyntax)SrsSyntax.AUTH_CODE, (boolean)false);
        if (identifier != null) {
            int idx = identifier.lastIndexOf(58);
            String authority = identifier.substring(0, idx);
            String code = identifier.substring(idx + 1);
            Set<String> supported = this.getStrategy().getSupportedCRSIdentifiers(this.getTypeName());
            for (String supportedSrs : supported) {
                if (!supportedSrs.contains(authority) || !supportedSrs.endsWith(":" + code)) continue;
                LOGGER.log(Level.FINE, "Found supportedSRS: " + supportedSrs);
                this.srsName = supportedSrs;
                break;
            }
        } else {
            LOGGER.log(Level.FINE, "GML2EncodingUtils couldn't handle the coordinate system: " + crs);
        }
    }

    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setMaxFeatures(Integer maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public void setSortBy(SortBy[] sortBy) {
        this.sortBy = sortBy;
    }

    public void setFullType(FeatureType fullType) {
        this.fullType = fullType;
    }

    public FeatureType getFullType() {
        return this.fullType;
    }

    public void setQueryType(FeatureType queryType) {
        this.queryType = queryType;
    }

    public FeatureType getQueryType() {
        return this.queryType;
    }

    public void setUnsupportedFilter(Filter unsupportedFilter) {
        this.unsupportedFilter = unsupportedFilter;
    }

    public Filter getUnsupportedFilter() {
        return this.unsupportedFilter == null ? Filter.INCLUDE : this.unsupportedFilter;
    }

    public boolean isStoredQuery() {
        return this.storedQuery;
    }

    public void setStoredQuery(boolean storedQuery) {
        this.storedQuery = storedQuery;
    }

    public void setHints(Hints hints) {
        this.hints = hints;
    }

    public Hints getHints() {
        return this.hints;
    }

    public StoredQueryDescriptionType getStoredQueryDescriptionType() {
        return this.storedQueryDescriptionType;
    }

    public void setStoredQueryDescriptionType(StoredQueryDescriptionType desc) {
        this.storedQueryDescriptionType = desc;
    }

    public static enum ResultType {
        RESULTS,
        HITS;

    }
}

