/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ho.yaml.YamlConfig;
import org.ho.yaml.exception.YamlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    public static PropertyDescriptor getPropertyDescriptor(Class clazz, String string) {
        try {
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (!string.equals(propertyDescriptor.getName())) continue;
                return propertyDescriptor;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return null;
    }

    public static boolean hasProperty(Class clazz, String string) {
        return null != ReflectionUtil.getPropertyDescriptor(clazz, string);
    }

    public static boolean hasProperty(Object object, String string) {
        return null != ReflectionUtil.getPropertyDescriptor(object.getClass(), string);
    }

    public static PropertyDescriptor getPropertyDescriptor(Object object, String string) {
        return ReflectionUtil.getPropertyDescriptor(object.getClass(), string);
    }

    public static List<PropertyDescriptor> getProperties(Object object) {
        return ReflectionUtil.getProperties(object.getClass());
    }

    public static List<PropertyDescriptor> getProperties(Class clazz) {
        try {
            return ReflectionUtil.filterProps(Introspector.getBeanInfo(clazz).getPropertyDescriptors());
        }
        catch (IntrospectionException introspectionException) {
            throw new YamlException(introspectionException);
        }
    }

    public static List<PropertyDescriptor> getPropertiesExcluding(List<String> list, Object object) {
        try {
            return ReflectionUtil.filterProps(Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors(), list);
        }
        catch (IntrospectionException introspectionException) {
            throw new YamlException(introspectionException);
        }
    }

    public static List<Field> getFields(Object object) {
        Field[] fieldArray;
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : fieldArray = object.getClass().getFields()) {
            arrayList.add(field);
        }
        return arrayList;
    }

    public static List<Field> getFieldsExcluding(List<String> list, Object object) {
        Field[] fieldArray;
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : fieldArray = object.getClass().getFields()) {
            for (String string : list) {
                if (string.equals(field.getName())) continue;
                arrayList.add(field);
            }
        }
        return arrayList;
    }

    public static boolean isMemberField(Field field) {
        return 0 == (8 & field.getModifiers());
    }

    public static boolean isAbstract(Class clazz) {
        return 0 == (0 & clazz.getModifiers());
    }

    static List<PropertyDescriptor> filterProps(PropertyDescriptor[] propertyDescriptorArray) {
        return ReflectionUtil.filterProps(propertyDescriptorArray, null);
    }

    static List<PropertyDescriptor> filterProps(PropertyDescriptor[] propertyDescriptorArray, List<String> list) {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            if (list != null) {
                if ("class".equals(propertyDescriptor.getName())) continue;
                for (String string : list) {
                    if (string.equals(propertyDescriptor.getName())) continue;
                    arrayList.add(propertyDescriptor);
                }
                continue;
            }
            if (propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null) continue;
            arrayList.add(propertyDescriptor);
        }
        return arrayList;
    }

    public static void setProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor propertyDescriptor = ReflectionUtil.getPropertyDescriptor(object, string);
        propertyDescriptor.getWriteMethod().invoke(object, object2);
    }

    public static Class getFieldType(Class clazz, String string) {
        try {
            Field field = clazz.getField(string);
            return field.getType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object readField(Object object, String string) {
        try {
            Field field = object.getClass().getField(string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setField(Object object, String string, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            field.setAccessible(true);
            field.set(object, object2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Object invokeConstructor(Class clazz, Class[] classArray, Object[] objectArray) {
        Constructor constructor = ReflectionUtil.getConstructor(clazz, classArray);
        try {
            Object t = constructor.newInstance(objectArray);
            return t;
        }
        catch (Exception exception) {
            throw new YamlException("Can't invoke constructor for " + clazz + " with arguments " + Arrays.asList(classArray) + " with values " + Arrays.asList(objectArray));
        }
    }

    public static Constructor getConstructor(Class clazz, Class[] classArray) {
        try {
            return clazz.getConstructor(classArray);
        }
        catch (Exception exception) {
            throw new YamlException("Can't find constructor for " + clazz + " with arguments " + Arrays.asList(classArray) + "\n" + exception);
        }
    }

    public static boolean isPrimitiveType(String string) {
        return Integer.TYPE.getName().equals(string) || Double.TYPE.getName().equals(string) || Float.TYPE.getName().equals(string) || Boolean.TYPE.getName().equals(string) || Character.TYPE.getName().equals(string) || Byte.TYPE.getName().equals(string) || Long.TYPE.getName().equals(string) || Short.TYPE.getName().equals(string) || Character.TYPE.getName().equals(string);
    }

    public static Class getPrimitiveType(String string) {
        if (Integer.TYPE.getName().equals(string)) {
            return Integer.TYPE;
        }
        if (Double.TYPE.getName().equals(string)) {
            return Double.TYPE;
        }
        if (Float.TYPE.getName().equals(string)) {
            return Float.TYPE;
        }
        if (Boolean.TYPE.getName().equals(string)) {
            return Boolean.TYPE;
        }
        if (Character.TYPE.getName().equals(string)) {
            return Character.TYPE;
        }
        if (Byte.TYPE.getName().equals(string)) {
            return Byte.TYPE;
        }
        if (Long.TYPE.getName().equals(string)) {
            return Long.TYPE;
        }
        if (Short.TYPE.getName().equals(string)) {
            return Short.TYPE;
        }
        if (Character.TYPE.getName().equals(string)) {
            return Character.TYPE;
        }
        throw new YamlException(string + " is not a primitive type.");
    }

    public static boolean isArrayName(String string) {
        return string != null && string.indexOf("[]") != -1;
    }

    public static String arrayComponentName(String string) {
        return string.substring(0, string.length() - 2);
    }

    public static Class getArrayType(String string) {
        if (ReflectionUtil.isArrayName(string)) {
            return ReflectionUtil.getArrayTypeHelper(string);
        }
        return null;
    }

    public static String arrayName(Class clazz, YamlConfig yamlConfig) {
        if (clazz.isArray()) {
            return ReflectionUtil.arrayName(clazz.getComponentType(), yamlConfig) + "[]";
        }
        if (yamlConfig != null) {
            return yamlConfig.classname2transfer(clazz.getName());
        }
        return clazz.getName();
    }

    public static Class classForName(String string) {
        if (ReflectionUtil.isPrimitiveType(string)) {
            return ReflectionUtil.getPrimitiveType(string);
        }
        if (ReflectionUtil.isArrayName(string)) {
            return ReflectionUtil.getArrayType(string);
        }
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String transfer2classname(String string, YamlConfig yamlConfig) {
        if (ReflectionUtil.isArrayName(string)) {
            return ReflectionUtil.transfer2classname(ReflectionUtil.arrayComponentName(string), yamlConfig) + "[]";
        }
        return yamlConfig.transfer2classname(string);
    }

    static Class getArrayTypeHelper(String string) {
        if (!ReflectionUtil.isArrayName(string)) {
            return ReflectionUtil.classForName(string);
        }
        return Array.newInstance(ReflectionUtil.getArrayTypeHelper(ReflectionUtil.arrayComponentName(string)), 0).getClass();
    }

    public static String className(Class clazz) {
        return ReflectionUtil.className(clazz, null);
    }

    public static String className(Class clazz, YamlConfig yamlConfig) {
        if (clazz.isArray()) {
            return ReflectionUtil.arrayName(clazz, yamlConfig);
        }
        if (yamlConfig != null) {
            return yamlConfig.classname2transfer(clazz.getName());
        }
        return clazz.getName();
    }

    public static boolean isSimpleType(Class clazz) {
        return clazz.isPrimitive() || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Short.class || clazz == Double.class || clazz == Float.class || clazz == Boolean.class || clazz == Character.class;
    }

    public static boolean isCastableFrom(Class clazz, Class clazz2) {
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz2.isPrimitive()) {
            try {
                if (clazz.getField("TYPE").get(clazz) == clazz2) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isCastableFrom(Class clazz, String string) {
        return ReflectionUtil.isCastableFrom(clazz, ReflectionUtil.classForName(string));
    }
}

