/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.geotools.api.metadata.citation.OnLineResource;
import org.geotools.api.style.ColorReplacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.util.Utilities;

public class ExternalGraphicImpl
implements Symbol,
Cloneable,
ExternalGraphic {
    private Icon inlineContent;
    private OnLineResource online;
    private URL location = null;
    private String uri = null;
    private String format = null;
    private Map<String, Object> customProps = null;
    private final Set<ColorReplacement> colorReplacements;

    public ExternalGraphicImpl() {
        this(null, null, null);
    }

    public ExternalGraphicImpl(Icon icon, Collection<ColorReplacement> replaces, OnLineResource source) {
        this.inlineContent = icon;
        this.colorReplacements = replaces == null ? new TreeSet<ColorReplacement>() : new TreeSet<ColorReplacement>(replaces);
        this.online = source;
        if (source != null) {
            this.uri = source.getLinkage().toString();
        }
    }

    public void setURI(String uri) {
        this.uri = uri;
        this.online = null;
        this.location = null;
    }

    public String getURI() {
        return this.uri;
    }

    public String getFormat() {
        return this.format;
    }

    public URL getLocation() throws MalformedURLException {
        if (this.uri == null) {
            return null;
        }
        if (this.location == null) {
            this.location = new URL(this.uri);
        }
        return this.location;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setLocation(URL location) {
        if (location == null) {
            throw new IllegalArgumentException("ExternalGraphic location URL cannot be null");
        }
        this.uri = location.toString();
        this.location = location;
        this.online = null;
    }

    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit((ExternalGraphic)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((ExternalGraphic)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.format != null) {
            result = 1000003 * result + this.format.hashCode();
        }
        if (this.uri != null) {
            result = 1000003 * result + this.uri.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof ExternalGraphicImpl) {
            ExternalGraphicImpl other = (ExternalGraphicImpl)oth;
            return Utilities.equals((Object)this.uri, (Object)other.uri) && Utilities.equals((Object)this.format, (Object)other.format);
        }
        return false;
    }

    public Map<String, Object> getCustomProperties() {
        return this.customProps;
    }

    public void setCustomProperties(Map<String, Object> list) {
        this.customProps = list;
    }

    public OnLineResource getOnlineResource() {
        if (this.online == null) {
            OnLineResourceImpl impl = new OnLineResourceImpl();
            try {
                impl.setLinkage(new URI(this.uri));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            this.online = impl;
        }
        return this.online;
    }

    public void setOnlineResource(OnLineResource online) {
        this.online = online;
        this.uri = online != null ? online.getLinkage().toString() : null;
        this.location = null;
    }

    public Icon getInlineContent() {
        return this.inlineContent;
    }

    public void setInlineContent(Icon inlineContent) {
        this.inlineContent = inlineContent;
    }

    public Collection<ColorReplacement> getColorReplacements() {
        return Collections.unmodifiableCollection(this.colorReplacements);
    }

    public Set<ColorReplacement> colorReplacements() {
        return this.colorReplacements;
    }

    static GraphicalSymbol cast(GraphicalSymbol item) {
        if (item == null) {
            return null;
        }
        if (item instanceof ExternalGraphicImpl) {
            return item;
        }
        if (item instanceof ExternalGraphic) {
            ExternalGraphic graphic = (ExternalGraphic)item;
            ExternalGraphicImpl copy = new ExternalGraphicImpl();
            copy.colorReplacements().addAll(graphic.getColorReplacements());
            copy.setFormat(graphic.getFormat());
            copy.setInlineContent(graphic.getInlineContent());
            copy.setOnlineResource(graphic.getOnlineResource());
            return copy;
        }
        return null;
    }
}

