/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.util.Utilities;

public class ChannelSelectionImpl
implements ChannelSelection {
    private SelectedChannelType gray;
    private SelectedChannelType red;
    private SelectedChannelType blue;
    private SelectedChannelType green;

    public SelectedChannelType getGrayChannel() {
        return this.gray;
    }

    public SelectedChannelType[] getRGBChannels() {
        if (this.red == null && this.green == null && this.blue == null) {
            return null;
        }
        return new SelectedChannelType[]{this.red, this.green, this.blue};
    }

    public void setGrayChannel(SelectedChannelType gray) {
        this.gray = gray;
    }

    public void setRGBChannels(SelectedChannelType ... channels) {
        if (channels == null) {
            this.red = null;
            this.green = null;
            this.blue = null;
        } else {
            if (channels.length != 3) {
                throw new IllegalArgumentException("Three channels are required in setRGBChannels, got " + channels.length);
            }
            this.red = channels[0];
            this.green = channels[1];
            this.blue = channels[2];
        }
    }

    public void setRGBChannels(SelectedChannelType red, SelectedChannelType green, SelectedChannelType blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit((ChannelSelection)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((ChannelSelection)this);
    }

    public void accept(TraversingStyleVisitor visitor) {
        visitor.visit((ChannelSelection)this, null);
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.gray != null) {
            result = 1000003 * result + this.gray.hashCode();
        }
        if (this.red != null) {
            result = 1000003 * result + this.red.hashCode();
        }
        if (this.blue != null) {
            result = 1000003 * result + this.blue.hashCode();
        }
        if (this.green != null) {
            result = 1000003 * result + this.green.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChannelSelectionImpl) {
            ChannelSelectionImpl other = (ChannelSelectionImpl)obj;
            return Utilities.equals((Object)this.gray, (Object)other.gray) && Utilities.equals((Object)this.red, (Object)other.red) && Utilities.equals((Object)this.blue, (Object)other.blue) && Utilities.equals((Object)this.green, (Object)other.green);
        }
        return false;
    }

    static ChannelSelectionImpl cast(ChannelSelection channel) {
        if (channel == null) {
            return null;
        }
        if (channel instanceof ChannelSelectionImpl) {
            return (ChannelSelectionImpl)channel;
        }
        ChannelSelectionImpl copy = new ChannelSelectionImpl();
        if (channel.getGrayChannel() != null) {
            copy.setGrayChannel(channel.getGrayChannel());
        } else {
            SelectedChannelType[] rgb = channel.getRGBChannels();
            copy.setRGBChannels(rgb[0], rgb[1], rgb[2]);
        }
        return copy;
    }
}

