/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReTypingFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.filter.FilterAttributeExtractor;

public class ReTypingFeatureCollection
extends DecoratingSimpleFeatureCollection {
    SimpleFeatureType featureType;

    public ReTypingFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, SimpleFeatureType featureType) {
        this(DataUtilities.simple(delegate), featureType);
    }

    public ReTypingFeatureCollection(SimpleFeatureCollection delegate, SimpleFeatureType featureType) {
        super(delegate);
        this.featureType = featureType;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(), this.features());
    }

    @Override
    public SimpleFeatureIterator features() {
        return new ReTypingFeatureIterator(this.delegate.features(), (SimpleFeatureType)this.delegate.getSchema(), this.featureType);
    }

    @Override
    protected boolean canDelegate(FeatureVisitor visitor) {
        return ReTypingFeatureCollection.isTypeCompatible(visitor, this.featureType);
    }

    public static boolean isTypeCompatible(FeatureVisitor visitor, SimpleFeatureType featureType) {
        if (visitor instanceof FeatureAttributeVisitor) {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(featureType);
            for (Expression e : ((FeatureAttributeVisitor)visitor).getExpressions()) {
                e.accept((ExpressionVisitor)extractor, null);
            }
            for (PropertyName pname : extractor.getPropertyNameSet()) {
                AttributeDescriptor att = (AttributeDescriptor)pname.evaluate((Object)featureType);
                if (att != null) continue;
                return false;
            }
            return true;
        }
        return visitor instanceof CountVisitor;
    }
}

