/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.OperationNotFoundException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.crs.ReprojectFeatureIterator;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class ReprojectFeatureResults
extends AbstractFeatureCollection {
    FeatureCollection<SimpleFeatureType, SimpleFeature> results;
    MathTransform transform;

    public ReprojectFeatureResults(FeatureCollection<SimpleFeatureType, SimpleFeature> results, CoordinateReferenceSystem destinationCS) throws IOException, SchemaException, TransformException, OperationNotFoundException, NoSuchElementException, FactoryException {
        super(ReprojectFeatureResults.forceType(ReprojectFeatureResults.origionalType(results), destinationCS));
        this.results = ReprojectFeatureResults.origionalCollection(results);
        CoordinateReferenceSystem originalCs = null;
        originalCs = results instanceof ForceCoordinateSystemFeatureResults ? results.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem() : this.results.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem();
        this.transform = CRS.findMathTransform(originalCs, destinationCS, true);
    }

    @Override
    public Iterator<SimpleFeature> openIterator() {
        return new ReprojectFeatureIterator(this.results.features(), this.getSchema(), this.transform);
    }

    public void closeIterator(Iterator close) {
        if (close == null) {
            return;
        }
        if (close instanceof ReprojectFeatureIterator) {
            ReprojectFeatureIterator iterator = (ReprojectFeatureIterator)close;
            iterator.close();
        }
    }

    @Override
    public int size() {
        return this.results.size();
    }

    private static FeatureCollection<SimpleFeatureType, SimpleFeature> origionalCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> results) {
        if (results instanceof ReprojectFeatureResults) {
            results = ((ReprojectFeatureResults)results).getOrigin();
        }
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            results = ((ForceCoordinateSystemFeatureResults)results).getOrigin();
        }
        return results;
    }

    private static SimpleFeatureType origionalType(FeatureCollection<SimpleFeatureType, SimpleFeature> results) {
        if (results instanceof ReprojectFeatureResults) {
            results = ((ReprojectFeatureResults)results).getOrigin();
        }
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            results = ((ForceCoordinateSystemFeatureResults)results).getOrigin();
        }
        return results.getSchema();
    }

    private static SimpleFeatureType forceType(SimpleFeatureType startingType, CoordinateReferenceSystem forcedCS) throws SchemaException {
        if (forcedCS == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        CoordinateReferenceSystem originalCs = startingType.getGeometryDescriptor().getCoordinateReferenceSystem();
        if (forcedCS.equals(originalCs)) {
            return startingType;
        }
        return FeatureTypes.transform(startingType, forcedCS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReferencedEnvelope getBounds() {
        try (SimpleFeatureIterator r = this.features();){
            Envelope newBBox = new Envelope();
            while (r.hasNext()) {
                SimpleFeature feature = (SimpleFeature)r.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (geometry == null) continue;
                Envelope internal = geometry.getEnvelopeInternal();
                newBBox.expandToInclude(internal);
            }
            Optional<CoordinateReferenceSystem> crs = Optional.ofNullable(this.getSchema().getGeometryDescriptor()).map(GeometryDescriptor::getCoordinateReferenceSystem);
            if (crs.isPresent()) {
                ReferencedEnvelope referencedEnvelope2 = ReferencedEnvelope.envelope(newBBox, crs.get());
                return referencedEnvelope2;
            }
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference(newBBox);
            return referencedEnvelope;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while computing reprojected bounds", e);
        }
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getOrigin() {
        return this.results;
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        if (this.canDelegate(visitor)) {
            this.results.accepts(visitor, progress);
        } else {
            super.accepts(visitor, progress);
        }
    }

    protected boolean canDelegate(FeatureVisitor visitor) {
        return ReprojectingFeatureCollection.isGeometryless(visitor, this.schema);
    }
}

