/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.locationtech.jts.geom.Geometry;

public class ReprojectFeatureIterator
implements Iterator<SimpleFeature>,
SimpleFeatureIterator {
    FeatureIterator<SimpleFeature> reader;
    SimpleFeatureType schema;
    GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();

    public ReprojectFeatureIterator(FeatureIterator<SimpleFeature> reader, SimpleFeatureType schema, MathTransform transform) {
        this.reader = reader;
        this.schema = schema;
        this.transformer.setMathTransform(transform);
        this.transformer.setCoordinateReferenceSystem(schema.getCoordinateReferenceSystem());
    }

    public SimpleFeatureType getFeatureType() {
        if (this.schema == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.schema;
    }

    @Override
    public SimpleFeature next() throws NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        SimpleFeature next = this.reader.next();
        Object[] attributes = next.getAttributes().toArray();
        try {
            for (int i = 0; i < attributes.length; ++i) {
                if (!(attributes[i] instanceof Geometry)) continue;
                attributes[i] = this.transformer.transform((Geometry)attributes[i]);
            }
        }
        catch (TransformException e) {
            throw (IllegalStateException)new IllegalStateException("A transformation exception occurred while reprojecting data on the fly").initCause(e);
        }
        return SimpleFeatureBuilder.build(this.schema, attributes, next.getID());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("On the fly reprojection disables remove");
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    @Override
    public void close() {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

