/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.api.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.factory.CommonFactoryFinder;

public class Join {
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    Type type;
    String typeName;
    List<PropertyName> properties = Query.ALL_PROPERTIES;
    Filter join;
    Filter filter;
    String alias;

    public Join(String typeName, Filter join) {
        this.typeName = typeName;
        this.join = join;
        this.type = Type.INNER;
        this.properties = Query.ALL_PROPERTIES;
        this.filter = Filter.INCLUDE;
        this.alias = null;
    }

    public Join(Join other) {
        this.typeName = other.getTypeName();
        this.join = other.getJoinFilter();
        this.filter = other.getFilter();
        this.type = other.getType();
        this.properties = other.getProperties();
        this.filter = other.getFilter();
        this.alias = other.getAlias();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Filter getJoinFilter() {
        return this.join;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public List<PropertyName> getProperties() {
        if (this.properties == Query.ALL_PROPERTIES) {
            return this.properties;
        }
        return Collections.unmodifiableList(this.properties);
    }

    public void setProperties(List<PropertyName> properties) {
        this.properties = properties;
    }

    public String[] getPropertyNames() {
        if (this.properties == Query.ALL_PROPERTIES) {
            return Query.ALL_NAMES;
        }
        String[] names = new String[this.properties.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.properties.get(i).getPropertyName();
        }
        return names;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public String attributeName() {
        return this.getAlias() != null ? this.getAlias() : this.getTypeName();
    }

    public Join properties(String ... properties) {
        this.properties = new ArrayList<PropertyName>();
        for (String p : properties) {
            this.properties.add(ff.property(p));
        }
        return this;
    }

    public Join filter(Filter filter) {
        this.setFilter(filter);
        return this;
    }

    public Join alias(String alias) {
        this.setAlias(alias);
        return this;
    }

    public Join type(Type type) {
        this.setType(type);
        return this;
    }

    public static enum Type {
        INNER,
        OUTER;

    }
}

