/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.util;

import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.imageio.ImageReadParam;
import javax.media.jai.PropertySource;
import javax.media.jai.ROI;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.geometry.PixelTranslation;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.util.Utilities;

public final class CoverageUtilities {
    public static final InternationalString NODATA = Vocabulary.formatInternational((int)147);
    public static final AffineTransform AXES_SWAP = new AffineTransform2D(0.0, 1.0, 1.0, 0.0, 0.0, 0.0);
    public static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform2D(AffineTransform.getRotateInstance(0.0));
    public static final AffineTransform CENTER_TO_CORNER = AffineTransform.getTranslateInstance(PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER), PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER));
    public static final AffineTransform CORNER_TO_CENTER = AffineTransform.getTranslateInstance(-PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER), -PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER));
    public static final double AFFINE_IDENTITY_EPS = 1.0E-6;

    private CoverageUtilities() {
    }

    public static CoordinateReferenceSystem getCRS2D(Coverage coverage) throws TransformException {
        if (coverage instanceof GridCoverage2D) {
            return ((GridCoverage2D)coverage).getCoordinateReferenceSystem2D();
        }
        if (coverage instanceof GridCoverage) {
            GridGeometry2D geometry = GridGeometry2D.wrap(((GridCoverage)coverage).getGridGeometry());
            if (geometry.isDefined(1)) {
                return geometry.getCoordinateReferenceSystem2D();
            }
            try {
                return geometry.reduce(coverage.getCoordinateReferenceSystem());
            }
            catch (FactoryException factoryException) {
                // empty catch block
            }
        }
        return CRSUtilities.getCRS2D(coverage.getCoordinateReferenceSystem());
    }

    public static CoordinateReferenceSystem getHorizontalCRS(Coverage coverage) throws TransformException {
        CoordinateReferenceSystem returnedCRS = null;
        if (coverage instanceof GridCoverage2D) {
            returnedCRS = ((GridCoverage2D)coverage).getCoordinateReferenceSystem2D();
        }
        if (coverage instanceof GridCoverage) {
            GridGeometry2D geometry = GridGeometry2D.wrap(((GridCoverage)coverage).getGridGeometry());
            if (geometry.isDefined(1)) {
                returnedCRS = geometry.getCoordinateReferenceSystem2D();
            } else {
                try {
                    returnedCRS = geometry.reduce(coverage.getCoordinateReferenceSystem());
                }
                catch (FactoryException factoryException) {
                    // empty catch block
                }
            }
        }
        if (returnedCRS == null) {
            returnedCRS = CRS.getHorizontalCRS(coverage.getCoordinateReferenceSystem());
        }
        if (returnedCRS == null) {
            throw new TransformException(MessageFormat.format("Can't reduce \"{0}\" to a two-dimensional coordinate system.", returnedCRS));
        }
        return returnedCRS;
    }

    public static ReferencedEnvelope getEnvelope2D(Coverage coverage) throws MismatchedDimensionException {
        if (coverage instanceof GridCoverage2D) {
            return ((GridCoverage2D)coverage).getEnvelope2D();
        }
        if (coverage instanceof GridCoverage) {
            GridGeometry2D geometry = GridGeometry2D.wrap(((GridCoverage)coverage).getGridGeometry());
            if (geometry.isDefined(2)) {
                return geometry.getEnvelope2D();
            }
            return geometry.reduce(coverage.getEnvelope());
        }
        return new ReferencedEnvelope(coverage.getEnvelope());
    }

    public static NoDataContainer getNoDataProperty(GridCoverage2D coverage) {
        Object noData = coverage.getProperty("GC_NODATA");
        if (noData != null) {
            if (noData instanceof NoDataContainer) {
                return (NoDataContainer)noData;
            }
            if (noData instanceof Double) {
                return new NoDataContainer(((Double)noData).doubleValue());
            }
        }
        return null;
    }

    public static ROI getROIProperty(GridCoverage2D coverage) {
        Object roi = coverage.getProperty("GC_ROI");
        if (roi != null && roi instanceof ROI) {
            return (ROI)roi;
        }
        return null;
    }

    public static void setNoDataProperty(Map<String, Object> properties, Object noData) {
        if (noData == null || properties == null) {
            return;
        }
        if (noData instanceof Range) {
            properties.put("GC_NODATA", new NoDataContainer((Range)noData));
        } else if (noData instanceof Double) {
            properties.put("GC_NODATA", new NoDataContainer(((Double)noData).doubleValue()));
        } else if (noData instanceof double[]) {
            properties.put("GC_NODATA", new NoDataContainer((double[])noData));
        } else if (noData instanceof NoDataContainer) {
            properties.put("GC_NODATA", new NoDataContainer((NoDataContainer)noData));
        }
    }

    public static void setROIProperty(Map<String, Object> properties, ROI roi) {
        if (properties == null) {
            return;
        }
        if (roi == null) {
            properties.remove("GC_ROI");
            return;
        }
        properties.put("GC_ROI", roi);
    }

    public static double[] getBackgroundValues(GridCoverage2D coverage) {
        if (coverage == null) {
            throw new NullPointerException(MessageFormat.format("\"{0}\" parameter should be not null and of type \"{1}\".", "coverage", "GridCoverage2D"));
        }
        Object noData = coverage.getProperty("GC_NODATA");
        if (noData != null && noData instanceof NoDataContainer) {
            return ((NoDataContainer)noData).getAsArray();
        }
        GridSampleDimension[] sampleDimensions = coverage.getSampleDimensions();
        double[] background = new double[sampleDimensions.length];
        boolean found = false;
        int dataType = coverage.getRenderedImage().getSampleModel().getDataType();
        for (int i = 0; i < background.length; ++i) {
            List<Category> categories = sampleDimensions[i].getCategories();
            if (categories != null && !categories.isEmpty()) {
                for (Category category : categories) {
                    if (!category.getName().equals(NODATA)) continue;
                    background[i] = category.getRange().getMinimum();
                    found = true;
                    break;
                }
            }
            if (found) continue;
            background[i] = CoverageUtilities.suggestNoDataValue(dataType).doubleValue();
        }
        return background;
    }

    public static boolean uses(GridCoverage coverage, RenderedImage image) {
        if (coverage != null) {
            if (coverage.getRenderedImage() == image) {
                return true;
            }
            List sources = coverage.getSources();
            if (sources != null) {
                for (GridCoverage source : sources) {
                    if (!CoverageUtilities.uses(source, image)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getVisibleBand(Object image) {
        Object candidate = null;
        if (image instanceof RenderedImage) {
            candidate = ((RenderedImage)image).getProperty("GC_VisibleBand");
        } else if (image instanceof PropertySource) {
            candidate = ((PropertySource)image).getProperty("GC_VisibleBand");
        }
        if (candidate instanceof Integer) {
            return (Integer)candidate;
        }
        return 0;
    }

    public static boolean isScaleTranslate(MathTransform transform, double EPS) {
        if (!(transform instanceof AffineTransform)) {
            return false;
        }
        AffineTransform at = (AffineTransform)transform;
        double rotation = Math.abs(XAffineTransform.getRotation(at));
        return rotation < EPS;
    }

    public static double[] getResolution(AffineTransform gridToCRS) {
        double[] requestedRes = null;
        if (gridToCRS != null) {
            requestedRes = new double[]{XAffineTransform.getScaleX0(gridToCRS), XAffineTransform.getScaleY0(gridToCRS)};
        }
        return requestedRes;
    }

    public static boolean isSimpleGridToWorldTransform(AffineTransform gridToCRS, double EPS) {
        double rotation = XAffineTransform.getRotation(gridToCRS);
        double quadrantRotation = Math.abs(rotation / 1.5707963267948966);
        return Math.abs(quadrantRotation - Math.floor(quadrantRotation)) < EPS;
    }

    public static boolean checkEmptySourceRegion(ImageReadParam readParameters, Rectangle dimensions) {
        Utilities.ensureNonNull((String)"readDimension", (Object)dimensions);
        Utilities.ensureNonNull((String)"readP", (Object)readParameters);
        Rectangle sourceRegion = readParameters.getSourceRegion();
        Rectangle.intersect(sourceRegion, dimensions, sourceRegion);
        if (sourceRegion.isEmpty()) {
            return true;
        }
        readParameters.setSourceRegion(sourceRegion);
        return false;
    }

    public static double getMosaicThreshold(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: {
                return 0.0;
            }
            case 3: {
                return -2.147483648E9;
            }
            case 2: {
                return -32768.0;
            }
            case 5: {
                return -1.7976931348623157E308;
            }
            case 4: {
                return -3.4028234663852886E38;
            }
        }
        return 0.0;
    }

    public static Number suggestNoDataValue(int dataType) {
        switch (dataType) {
            case 0: {
                return (byte)0;
            }
            case 1: {
                return (short)0;
            }
            case 3: {
                return Integer.MIN_VALUE;
            }
            case 2: {
                return (short)Short.MIN_VALUE;
            }
            case 5: {
                return Double.NaN;
            }
            case 4: {
                return Float.valueOf(Float.NaN);
            }
        }
        throw new IllegalAccessError(MessageFormat.format("Illegal argument: \"{0}={1}\".", "dataType", dataType));
    }

    public static Properties loadPropertiesFromURL(URL propsURL) {
        Utilities.ensureNonNull((String)"propsURL", (Object)propsURL);
        Properties properties = new Properties();
        try (BufferedInputStream stream = new BufferedInputStream(propsURL.openStream());){
            properties.load(stream);
        }
        catch (IOException e) {
            if (FeatureUtilities.LOGGER.isLoggable(Level.SEVERE)) {
                FeatureUtilities.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        return properties;
    }

    public static class UCUM {
        public static final UCUMUnit TIME_UNITS = new UCUMUnit("second", "s");
        public static final UCUMUnit ELEVATION_UNITS = new UCUMUnit("meter", "m");

        public static class UCUMUnit {
            private String name;
            private String symbol;

            public UCUMUnit(String name, String symbol) {
                this.name = name;
                this.symbol = symbol;
            }

            public String getName() {
                return this.name;
            }

            public String getSymbol() {
                return this.symbol;
            }
        }
    }
}

