/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.WarpGrid;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationFactory;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.MathTransformFactory;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CannotReprojectException;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.WarpBuilder;
import org.geotools.util.Utilities;
import org.geotools.util.XArray;
import org.geotools.util.factory.Hints;

final class Resampler2D
extends GridCoverage2D {
    private static final long serialVersionUID = -8593569923766544474L;
    private static final PixelOrientation CORNER = PixelOrientation.UPPER_LEFT;
    private static final int EMPIRICAL_ADJUSTMENT_STEPS = 16;
    private static final double EPS = 1.0E-6;
    private static final Level LOGGING_LEVEL = Level.FINE;

    private Resampler2D(GridCoverage2D source, PlanarImage image, GridGeometry2D geometry, GridSampleDimension[] sampleDimensions, Map<String, Object> properties, Hints hints) {
        super((CharSequence)source.getName(), image, geometry, sampleDimensions, new GridCoverage2D[]{source}, properties, hints);
    }

    private static GridCoverage2D create(GridCoverage2D source, PlanarImage image, GridGeometry2D geometry, String operation, Warp warp, Hints hints, Map<String, Object> inProperties) {
        GridSampleDimension[] sampleDimensions = source.getSampleDimensions();
        if (sampleDimensions != null && Resampler2D.isColorModelExpanded(source.getRenderedImage(), hints)) {
            sampleDimensions = null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (operation != null) {
            properties.put("method", operation);
            if (warp != null) {
                properties.put("warpType", warp.getClass());
                if (warp instanceof WarpGrid) {
                    WarpGrid grid = (WarpGrid)warp;
                    Dimension dimension = new Dimension(grid.getXNumCells(), grid.getYNumCells());
                    properties.put("gridDimensions", dimension);
                }
            }
        }
        properties.putAll(inProperties);
        Resampler2D coverage = new Resampler2D(source, image, geometry, sampleDimensions, properties, hints);
        return coverage;
    }

    public static GridCoverage2D reproject(GridCoverage2D sourceCoverage, CoordinateReferenceSystem targetCRS, GridGeometry2D targetGG, Interpolation interpolation, Hints hints) throws FactoryException, TransformException {
        return Resampler2D.reproject(sourceCoverage, targetCRS, targetGG, interpolation, hints, null);
    }

    public static GridCoverage2D reproject(GridCoverage2D sourceCoverage, CoordinateReferenceSystem targetCRS, GridGeometry2D targetGG, Interpolation interpolation, Hints hints, double[] backgroundValues) throws FactoryException, TransformException {
        String operation;
        ImageLayout layout;
        LinearTransform allSteps;
        MathTransform step3;
        LinearTransform step2;
        MathTransform step1;
        GridGeometry2D sourceGG;
        boolean automaticGR;
        boolean automaticGG;
        CoordinateReferenceSystem targetGGCRS;
        Utilities.ensureNonNull((String)"sourceCoverage", (Object)((Object)sourceCoverage));
        CoordinateReferenceSystem sourceCRS = sourceCoverage.getCoordinateReferenceSystem();
        if (targetCRS == null) {
            targetCRS = targetGG != null && targetGG.isDefined(1) ? targetGG.getCoordinateReferenceSystem() : sourceCRS;
        } else if (targetGG != null && targetGG.isDefined(1) && !CRS.equalsIgnoreMetadata(targetCRS, targetGGCRS = targetGG.getCoordinateReferenceSystem()) && !CRS.findMathTransform(targetCRS, targetGGCRS).isIdentity()) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal value for argument \"{0}\".", "TargetCRS must be compatible with TargetGG CRS"));
        }
        if (interpolation == null) {
            if (hints != null && hints.containsKey((Object)JAI.KEY_INTERPOLATION)) {
                interpolation = (Interpolation)hints.get((Object)JAI.KEY_INTERPOLATION);
            }
        } else {
            hints.put((Object)JAI.KEY_INTERPOLATION, (Object)interpolation);
        }
        if (hints != null && !hints.containsKey((Object)JAI.KEY_BORDER_EXTENDER)) {
            hints.put((Object)JAI.KEY_BORDER_EXTENDER, (Object)BorderExtender.createInstance((int)1));
        }
        if (targetGG == null) {
            automaticGG = true;
            automaticGR = true;
        } else {
            boolean bl = automaticGR = !targetGG.isDefined(4);
            if (!automaticGR || targetGG.isDefined(8)) {
                automaticGG = false;
            } else if (targetGG.isDefined(2)) {
                MathTransform2D gridToCRS;
                Bounds envelope = targetGG.getEnvelope();
                sourceGG = sourceCoverage.getGridGeometry();
                switch (envelope.getDimension()) {
                    case 2: {
                        gridToCRS = sourceGG.getGridToCRS2D(CORNER);
                        break;
                    }
                    default: {
                        gridToCRS = sourceGG.getGridToCRS(CORNER);
                    }
                }
                targetGG = new GridGeometry2D(PixelInCell.CELL_CENTER, (MathTransform)gridToCRS, envelope, null);
                automaticGG = false;
            } else {
                targetGG = null;
                automaticGG = true;
            }
        }
        GridCoverage2D targetCoverage = Resampler2D.existingCoverage(sourceCoverage, targetCRS, targetGG);
        if (targetCoverage != null) {
            return targetCoverage;
        }
        sourceGG = sourceCoverage.getGridGeometry();
        CoordinateReferenceSystem compatibleSourceCRS = Resampler2D.compatibleSourceCRS(sourceCoverage.getCoordinateReferenceSystem2D(), sourceCRS, targetCRS);
        PlanarImage sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceCoverage.getRenderedImage());
        assert (sourceCoverage.getCoordinateReferenceSystem() == sourceCRS) : sourceCoverage;
        HashMap<String, Object> sourceProps = sourceCoverage.getProperties();
        sourceProps = sourceProps != null ? new HashMap<String, Object>(sourceProps) : new HashMap();
        Object roiProp = sourceProps.get("GC_ROI");
        NoDataContainer nodataProp = CoverageUtilities.getNoDataProperty(sourceCoverage);
        ROI roi = roiProp != null && roiProp instanceof ROI ? (ROI)roiProp : null;
        Range nodata = nodataProp != null ? nodataProp.getAsRange() : null;
        CoordinateOperationFactory factory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
        MathTransformFactory mtFactory = factory instanceof AbstractCoordinateOperationFactory ? ((AbstractCoordinateOperationFactory)factory).getMathTransformFactory() : ReferencingFactoryFinder.getMathTransformFactory(hints);
        if (CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            if (!targetGG.isDefined(8)) {
                step1 = sourceGG.getGridToCRS(CORNER);
                step2 = IdentityTransform.create(step1.getTargetDimensions());
                step3 = step1.inverse();
                allSteps = IdentityTransform.create(step1.getSourceDimensions());
                targetGG = new GridGeometry2D(targetGG.getGridRange(), step1, targetCRS);
            } else {
                step1 = targetGG.getGridToCRS(CORNER);
                step2 = IdentityTransform.create(step1.getTargetDimensions());
                step3 = sourceGG.getGridToCRS(CORNER).inverse();
                allSteps = mtFactory.createConcatenatedTransform(step1, step3);
                if (!targetGG.isDefined(4)) {
                    Bounds gridRange = Resampler2D.toEnvelope(sourceGG.getGridRange());
                    gridRange = CRS.transform(allSteps.inverse(), gridRange);
                    targetGG = new GridGeometry2D(new GeneralGridEnvelope(gridRange, PixelInCell.CELL_CORNER), targetGG.getGridToCRS(PixelInCell.CELL_CENTER), targetCRS);
                }
            }
        } else {
            if (sourceCRS == null) {
                throw new CannotReprojectException("Coordinate reference system is unspecified.");
            }
            CoordinateOperation operation2 = factory.createOperation(sourceCRS, targetCRS);
            boolean force2D = sourceCRS != compatibleSourceCRS;
            step2 = factory.createOperation(targetCRS, compatibleSourceCRS).getMathTransform();
            step3 = (force2D ? sourceGG.getGridToCRS2D(CORNER) : sourceGG.getGridToCRS(CORNER)).inverse();
            Bounds sourceEnvelope = sourceCoverage.getEnvelope();
            GeneralBounds targetEnvelope = CRS.transform(operation2, sourceEnvelope);
            targetEnvelope.setCoordinateReferenceSystem(targetCRS);
            if (targetGG == null) {
                GridEnvelope2D targetGR = force2D ? new GridEnvelope2D(sourceGG.getGridRange2D()) : sourceGG.getGridRange();
                targetGG = new GridGeometry2D(targetGR, targetEnvelope);
                step1 = targetGG.getGridToCRS(CORNER);
            } else if (!targetGG.isDefined(8)) {
                targetGG = new GridGeometry2D(targetGG.getGridRange(), targetEnvelope);
                step1 = targetGG.getGridToCRS(CORNER);
            } else {
                step1 = targetGG.getGridToCRS(CORNER);
                if (!targetGG.isDefined(4)) {
                    GeneralBounds gridRange = CRS.transform(step1.inverse(), (Bounds)targetEnvelope);
                    targetGG = new GridGeometry2D(new GeneralGridEnvelope(gridRange, PixelInCell.CELL_CENTER), step1, targetCRS);
                }
            }
            allSteps = mtFactory.createConcatenatedTransform(mtFactory.createConcatenatedTransform(step1, (MathTransform)step2), step3);
        }
        MathTransform2D allSteps2D = Resampler2D.toMathTransform2D(allSteps, mtFactory, targetGG);
        if (!(allSteps2D instanceof MathTransform2D)) {
            throw new TransformException("No two-dimensional transform available for this geometry.");
        }
        RenderingHints targetHints = ImageUtilities.getRenderingHints((RenderedImage)sourceImage);
        if (targetHints == null) {
            targetHints = new RenderingHints(JAI.KEY_INTERPOLATION, Interpolation.getInstance((int)0));
        } else {
            targetHints.put(JAI.KEY_INTERPOLATION, Interpolation.getInstance((int)0));
        }
        targetHints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, (Object)false);
        targetHints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, (Object)false);
        if (hints != null) {
            targetHints.add((RenderingHints)hints);
        }
        layout = (layout = (ImageLayout)targetHints.get(JAI.KEY_IMAGE_LAYOUT)) != null ? (ImageLayout)layout.clone() : new ImageLayout();
        GridEnvelope2D sourceBB = sourceGG.getGridRange2D();
        GridEnvelope2D targetBB = targetGG.getGridRange2D();
        if (Resampler2D.isBoundsUndefined(layout, false)) {
            layout.setMinX(targetBB.x);
            layout.setMinY(targetBB.y);
            layout.setWidth(targetBB.width);
            layout.setHeight(targetBB.height);
        }
        if (Resampler2D.isBoundsUndefined(layout, true)) {
            Dimension size = new Dimension(layout.getWidth((RenderedImage)sourceImage), layout.getHeight((RenderedImage)sourceImage));
            size = ImageUtilities.toTileSize(size);
            layout.setTileGridXOffset(layout.getMinX((RenderedImage)sourceImage));
            layout.setTileGridYOffset(layout.getMinY((RenderedImage)sourceImage));
            layout.setTileWidth(size.width);
            layout.setTileHeight(size.height);
        }
        double[] background = backgroundValues != null ? backgroundValues : CoverageUtilities.getBackgroundValues(sourceCoverage);
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        ImageWorker w = new ImageWorker((RenderedImage)sourceImage);
        w.setROI(roi);
        w.setBackground(background);
        w.setNoData(nodata);
        w.setRenderingHints(targetHints);
        ROI newROI = null;
        Range newNoData = null;
        HashMap<String, Object> imageProperties = new HashMap<String, Object>();
        Warp warp = null;
        if (allSteps.isIdentity() || allSteps instanceof AffineTransform && XAffineTransform.isIdentity((AffineTransform)((Object)allSteps), 1.0E-6)) {
            sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceCoverage.getRenderedImage());
            w.setImage((RenderedImage)sourceImage);
            if (targetBB.equals(sourceBB)) {
                sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceCoverage.getRenderedImage());
                return Resampler2D.create(sourceCoverage, sourceImage, targetGG, null, null, hints, sourceProps);
            }
            if (sourceBB.contains(targetBB)) {
                w.crop(Float.valueOf(targetBB.x).floatValue(), Float.valueOf(targetBB.y).floatValue(), Float.valueOf(targetBB.width).floatValue(), Float.valueOf(targetBB.height).floatValue());
                newROI = w.getROI();
                newNoData = w.getNoData();
                CoverageUtilities.setROIProperty(sourceProps, newROI);
                CoverageUtilities.setNoDataProperty(sourceProps, newNoData);
                operation = "Crop";
            } else {
                Range[] rangeArray;
                w.setNoData(null);
                RenderedImage[] renderedImageArray = new RenderedImage[]{sourceImage};
                ROI[] rOIArray = new ROI[]{roi};
                if (nodata != null) {
                    Range[] rangeArray2 = new Range[1];
                    rangeArray = rangeArray2;
                    rangeArray2[0] = nodata;
                } else {
                    rangeArray = null;
                }
                w.mosaic(renderedImageArray, MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, rOIArray, null, rangeArray);
                newROI = w.getROI();
                newNoData = w.getNoData();
                CoverageUtilities.setROIProperty(sourceProps, newROI);
                CoverageUtilities.setNoDataProperty(sourceProps, newNoData);
                operation = "Mosaic";
            }
        } else if ((automaticGR || targetBB.equals(sourceBB)) && allSteps instanceof AffineTransform) {
            if (automaticGG) {
                MathTransform mtr = sourceGG.getGridToCRS(CORNER);
                mtr = mtFactory.createConcatenatedTransform(mtr, step2.inverse());
                targetGG = new GridGeometry2D(sourceGG.getGridRange(), mtr, targetCRS);
                return Resampler2D.create(sourceCoverage, sourceImage, targetGG, null, null, hints, sourceProps);
            }
            AffineTransform affine = (AffineTransform)allSteps.inverse();
            w.affine(affine, interpolation, backgroundValues);
            operation = "Affine";
            newROI = w.getROI();
            newNoData = w.getNoData();
            CoverageUtilities.setROIProperty(sourceProps, newROI);
            CoverageUtilities.setNoDataProperty(sourceProps, newNoData);
        } else {
            boolean forceAdapter = false;
            if (!JAIExt.isJAIExtOperation((String)"Warp")) {
                switch (sourceImage.getSampleModel().getTransferType()) {
                    case 4: 
                    case 5: {
                        GeneralBounds source = CRS.transform(sourceGG.getEnvelope(), targetCRS);
                        GeneralBounds generalBounds = CRS.transform(targetGG.getEnvelope(), targetCRS);
                        source = targetGG.reduce(source);
                        ReferencedEnvelope referencedEnvelope = targetGG.reduce(generalBounds);
                        if (new GeneralBounds(source).contains((Bounds)referencedEnvelope, true)) break;
                        if (interpolation != null && !(interpolation instanceof InterpolationNearest)) {
                            hints.add(ImageUtilities.NN_INTERPOLATION_HINT);
                            return Resampler2D.reproject(sourceCoverage, targetCRS, targetGG, null, hints, background);
                        }
                        forceAdapter = true;
                    }
                }
            }
            MathTransform2D transform = allSteps2D;
            InternationalString internationalString = sourceCoverage.getName();
            operation = "Warp";
            warp = forceAdapter ? new WarpBuilder(0.0).buildWarp(transform, sourceBB) : Resampler2D.createWarp((CharSequence)internationalString, sourceBB, targetBB, transform, mtFactory, hints);
            imageProperties.put("MathTransform", transform);
            imageProperties.put("SourceBoundingBox", sourceBB);
            w.warp(warp, interpolation);
            newROI = w.getROI();
            newNoData = w.getNoData();
            CoverageUtilities.setROIProperty(sourceProps, newROI);
            CoverageUtilities.setNoDataProperty(sourceProps, newNoData);
        }
        RenderedOp targetImage = w.getRenderedOperation();
        for (Map.Entry entry : imageProperties.entrySet()) {
            targetImage.setProperty((String)entry.getKey(), entry.getValue());
        }
        Locale locale = sourceCoverage.getLocale();
        GridEnvelope gridEnvelope = targetGG.getGridRange();
        int[] lower = gridEnvelope.getLow().getCoordinateValues();
        int[] upper = gridEnvelope.getHigh().getCoordinateValues();
        Resampler2D.offsetUpper(upper);
        lower[targetGG.gridDimensionX] = targetImage.getMinX();
        lower[targetGG.gridDimensionY] = targetImage.getMinY();
        upper[targetGG.gridDimensionX] = targetImage.getMaxX();
        upper[targetGG.gridDimensionY] = targetImage.getMaxY();
        GeneralGridEnvelope actualGR = new GeneralGridEnvelope(lower, upper);
        if (!gridEnvelope.equals(actualGR)) {
            targetGG = new GridGeometry2D(actualGR, targetGG.getGridToCRS(PixelInCell.CELL_CENTER), targetCRS);
            if (!automaticGR) {
                Resampler2D.log(Loggings.getResources((Locale)locale).getLogRecord(Level.FINE, 0, (Object)sourceCoverage.getName().toString(locale)));
            }
        }
        targetCoverage = Resampler2D.create(sourceCoverage, (PlanarImage)targetImage, targetGG, operation, warp, hints, sourceProps);
        assert (CRS.equalsIgnoreMetadata(targetCoverage.getCoordinateReferenceSystem(), targetCRS)) : targetGG;
        assert (targetCoverage.getGridGeometry().getGridRange2D().equals(targetImage.getBounds())) : targetGG;
        if (CoverageProcessor.LOGGER.isLoggable(LOGGING_LEVEL)) {
            String bgParameter = background != null ? (background.length == 1 ? (Double.isNaN(background[0]) ? "NaN" : Double.valueOf(background[0])) : XArray.toString((Object)background, (Locale)locale)) : "No background used";
            Resampler2D.log(Loggings.getResources((Locale)locale).getLogRecord(LOGGING_LEVEL, 3, (Object)new Object[]{sourceCoverage.getName().toString(locale), sourceCoverage.getCoordinateReferenceSystem().getName().getCode(), sourceImage.getWidth(), sourceImage.getHeight(), targetCoverage.getCoordinateReferenceSystem().getName().getCode(), targetImage.getWidth(), targetImage.getHeight(), targetImage.getOperationName(), 1, ImageUtilities.getInterpolationName(interpolation), bgParameter}));
        }
        return targetCoverage;
    }

    private static void offsetUpper(int[] upper) {
        int i = 0;
        while (i < upper.length) {
            int n = i++;
            upper[n] = upper[n] + 1;
        }
    }

    private static GridCoverage2D existingCoverage(GridCoverage2D coverage, CoordinateReferenceSystem targetCRS, GridGeometry2D targetGG) {
        boolean hasNoData;
        ROI roiProp = CoverageUtilities.getROIProperty(coverage);
        NoDataContainer nodataProp = CoverageUtilities.getNoDataProperty(coverage);
        boolean hasROI = roiProp != null;
        boolean bl = hasNoData = nodataProp != null;
        if (hasROI || hasNoData) {
            return null;
        }
        while (!Resampler2D.equivalent(coverage.getGridGeometry(), targetGG) || !CRS.equalsIgnoreMetadata(targetCRS, coverage.getCoordinateReferenceSystem()) && !CRS.equalsIgnoreMetadata(targetCRS, coverage.getCoordinateReferenceSystem2D())) {
            if (!(coverage instanceof Resampler2D)) {
                return null;
            }
            List<GridCoverage> sources = coverage.getSources();
            assert (sources.size() == 1) : sources;
            coverage = (GridCoverage2D)sources.get(0);
        }
        return coverage;
    }

    private static boolean isBoundsUndefined(ImageLayout layout, boolean tile) {
        int mask = tile ? 240 : 15;
        return (layout.getValidMask() & mask) == 0;
    }

    private static boolean isColorModelExpanded(RenderedImage image, Hints hints) {
        Boolean replace;
        if (image.getColorModel() instanceof IndexColorModel && hints != null && hints.containsKey((Object)JAI.KEY_REPLACE_INDEX_COLOR_MODEL) && (replace = (Boolean)hints.get((Object)JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) != null) {
            return replace;
        }
        return false;
    }

    private static CoordinateReferenceSystem compatibleSourceCRS(CoordinateReferenceSystem sourceCRS2D, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        int dim2D = sourceCRS2D.getCoordinateSystem().getDimension();
        return targetCRS.getCoordinateSystem().getDimension() == dim2D && sourceCRS.getCoordinateSystem().getDimension() > dim2D ? sourceCRS2D : sourceCRS;
    }

    private static MathTransform2D toMathTransform2D(MathTransform transform, MathTransformFactory mtFactory, GridGeometry2D sourceGG) throws FactoryException {
        DimensionFilter filter = new DimensionFilter(mtFactory);
        filter.addSourceDimension(sourceGG.axisDimensionX);
        filter.addSourceDimension(sourceGG.axisDimensionY);
        MathTransform candidate = filter.separate(transform);
        if (candidate instanceof MathTransform2D) {
            return (MathTransform2D)candidate;
        }
        filter.addTargetDimension(sourceGG.axisDimensionX);
        filter.addTargetDimension(sourceGG.axisDimensionY);
        candidate = filter.separate(transform);
        if (candidate instanceof MathTransform2D) {
            return (MathTransform2D)candidate;
        }
        throw new FactoryException("No two-dimensional transform available for this geometry.");
    }

    private static boolean equivalent(GridGeometry2D sourceGG, GridGeometry2D targetGG) {
        if (targetGG == null || targetGG.equals(sourceGG)) {
            return true;
        }
        if (targetGG.isDefined(4) && sourceGG.isDefined(4) && !targetGG.getGridRange().equals(sourceGG.getGridRange())) {
            return false;
        }
        return !targetGG.isDefined(8) || !sourceGG.isDefined(8) || targetGG.getGridToCRS().equals(sourceGG.getGridToCRS());
    }

    private static Bounds toEnvelope(GridEnvelope gridRange) {
        int dimension = gridRange.getDimension();
        double[] lower = new double[dimension];
        double[] upper = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            lower[i] = gridRange.getLow(i);
            upper[i] = gridRange.getHigh(i) + 1;
        }
        return new GeneralBounds(lower, upper);
    }

    private static Warp createWarp(CharSequence name, Rectangle sourceBB, Rectangle targetBB, MathTransform2D allSteps2D, MathTransformFactory mtFactory, Hints hints) throws FactoryException, TransformException {
        Double tolerance = (Double)hints.get((Object)Hints.RESAMPLE_TOLERANCE);
        if (tolerance == null) {
            tolerance = (Double)Hints.getSystemDefault((RenderingHints.Key)Hints.RESAMPLE_TOLERANCE);
        }
        if (tolerance == null) {
            tolerance = Hints.DEFAULT_RESAMPLE_TOLERANCE;
        }
        WarpBuilder wb = new WarpBuilder(tolerance);
        MathTransform2D transform = allSteps2D;
        Object actualBB = null;
        boolean step = false;
        if (actualBB != null) {
            double scaleX = 1.0 - (double)sourceBB.width / (double)actualBB.width;
            double scaleY = 1.0 - (double)sourceBB.height / (double)actualBB.height;
            double translateX = sourceBB.x - actualBB.x;
            double translateY = sourceBB.y - actualBB.y;
            double factor = (double)step / 16.0;
            AffineTransform2D adjustment = new AffineTransform2D(1.0 - scaleX * factor, 0.0, 0.0, 1.0 - scaleY * factor, translateX * factor, translateY * factor);
            transform = (MathTransform2D)mtFactory.createConcatenatedTransform((MathTransform)allSteps2D, (MathTransform)adjustment);
        }
        Warp warp = wb.buildWarp(transform, targetBB);
        return warp;
    }

    private static void log(LogRecord record) {
        record.setSourceClassName("Resample");
        record.setSourceMethodName("doOperation");
        Logger logger = CoverageProcessor.LOGGER;
        record.setLoggerName(logger.getName());
        logger.log(record);
    }
}

