/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.FileSetManager;

public class FileSystemFileSetManager
implements FileSetManager {
    private static Logger LOGGER = Logger.getLogger(FileSystemFileSetManager.class.toString());
    private List<String> fileSet = Collections.synchronizedList(new ArrayList());

    @Override
    public void addFile(String filePath) {
        this.fileSet.add(filePath);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding file " + filePath + " to the fileSet");
        }
    }

    @Override
    public List<String> list() {
        return Collections.unmodifiableList(this.fileSet);
    }

    @Override
    public void removeFile(String filePath) {
        boolean contains;
        block7: {
            contains = this.fileSet.contains(filePath);
            if (contains) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Removing file " + filePath + " to the fileSet and deleting it");
                }
                try {
                    File[] files;
                    File file = new File(filePath);
                    if (file.isDirectory() && (files = file.listFiles()) != null) {
                        for (File _file : files) {
                            this.deleteFile(_file);
                        }
                    }
                    this.deleteFile(file);
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block7;
                    LOGGER.fine("Exception occurred while deleting file: " + filePath + "\n" + t.getLocalizedMessage());
                }
            }
        }
        if (contains) {
            this.fileSet.remove(filePath);
        }
    }

    private void deleteFile(File file) {
        boolean deleted = file.delete();
        if (!deleted && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unable to delete file " + file.getAbsolutePath());
        }
    }

    @Override
    public void purge() {
        if (!this.fileSet.isEmpty()) {
            String[] files;
            for (String filePath : files = this.fileSet.toArray(new String[this.fileSet.size()])) {
                this.removeFile(filePath);
            }
        }
    }
}

