/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.webjars.WebJarAssetLocator;
import org.xml.sax.SAXException;

public final class RequireJS {
    public static final String WEBJARS_MAVEN_PREFIX = "META-INF/maven/org.webjars";
    private static final Logger log = LoggerFactory.getLogger(RequireJS.class);
    private static String requireConfigJavaScript;
    private static String requireConfigJavaScriptCdn;
    private static Map<String, ObjectNode> requireConfigJson;
    private static Map<String, ObjectNode> requireConfigJsonCdn;

    public static synchronized String getSetupJavaScript(String urlPrefix) {
        if (requireConfigJavaScript == null) {
            ArrayList<String> prefixes = new ArrayList<String>();
            prefixes.add(urlPrefix);
            requireConfigJavaScript = RequireJS.generateSetupJavaScript(prefixes);
        }
        return requireConfigJavaScript;
    }

    public static synchronized String getSetupJavaScript(String cdnPrefix, String urlPrefix) {
        if (requireConfigJavaScriptCdn == null) {
            ArrayList<String> prefixes = new ArrayList<String>();
            prefixes.add(cdnPrefix);
            prefixes.add(urlPrefix);
            requireConfigJavaScriptCdn = RequireJS.generateSetupJavaScript(prefixes);
        }
        return requireConfigJavaScriptCdn;
    }

    public static String generateSetupJavaScript(List<String> prefixes) {
        Map webJars = new WebJarAssetLocator().getWebJars();
        return RequireJS.generateSetupJavaScript(prefixes, webJars);
    }

    @Deprecated
    public static String generateSetupJavaScript(List<String> prefixes, Map<String, String> webJars) {
        ArrayList<Map.Entry<String, Boolean>> prefixesWithVersion = new ArrayList<Map.Entry<String, Boolean>>();
        for (String prefix : prefixes) {
            prefixesWithVersion.add(new AbstractMap.SimpleEntry<String, Boolean>(prefix, true));
        }
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode webJarsVersions = mapper.createObjectNode();
        StringBuilder webJarConfigsString = new StringBuilder();
        if (webJars.isEmpty()) {
            log.warn("Can't find any WebJars in the classpath, RequireJS configuration will be empty.");
        } else {
            for (Map.Entry<String, String> webJar : webJars.entrySet()) {
                webJarsVersions.put(webJar.getKey(), webJar.getValue());
                ObjectNode webJarObjectNode = RequireJS.getWebJarSetupJson(webJar, prefixesWithVersion);
                if ((webJarObjectNode != null ? webJarObjectNode.size() : 0) != 0) {
                    webJarConfigsString.append("\n").append("requirejs.config(").append(webJarObjectNode.toString()).append(");");
                    continue;
                }
                webJarConfigsString.append("\n").append(RequireJS.getWebJarConfig(webJar));
            }
        }
        String webJarBasePath = "webJarId + '/' + webjars.versions[webJarId] + '/' + path";
        StringBuilder webJarPath = new StringBuilder("[");
        for (String prefix : prefixes) {
            webJarPath.append("'").append(prefix).append("' + ").append(webJarBasePath).append(",\n");
        }
        webJarPath.delete(webJarPath.lastIndexOf(",\n"), webJarPath.lastIndexOf(",\n") + 2);
        webJarPath.append("]");
        return "var webjars = {\n    versions: " + webJarsVersions.toString() + ",\n    path: function(webJarId, path) {\n        console.error('The webjars.path() method of getting a WebJar path has been deprecated.  The RequireJS config in the ' + webJarId + ' WebJar may need to be updated.  Please file an issue: http://github.com/webjars/' + webJarId + '/issues/new');\n        return " + webJarPath.toString() + ";\n    }\n};\n\nvar require = {\n    callback: function() {\n        // Deprecated WebJars RequireJS plugin loader\n        define('webjars', function() {\n            return {\n                load: function(name, req, onload, config) {\n                    if (name.indexOf('.js') >= 0) {\n                        console.warn('Detected a legacy file name (' + name + ') as the thing to load.  Loading via file name is no longer supported so the .js will be dropped in an effort to resolve the module name instead.');\n                        name = name.replace('.js', '');\n                    }\n                    console.error('The webjars plugin loader (e.g. webjars!' + name + ') has been deprecated.  The RequireJS config in the ' + name + ' WebJar may need to be updated.  Please file an issue: http://github.com/webjars/webjars/issues/new');\n                    req([name], function() {\n                        onload();\n                    });\n                }\n            }\n        });\n\n        // All of the WebJar configs\n\n" + webJarConfigsString + "    }\n};";
    }

    public static synchronized Map<String, ObjectNode> getSetupJson(String urlPrefix) {
        if (requireConfigJson == null) {
            ArrayList<Map.Entry<String, Boolean>> prefixes = new ArrayList<Map.Entry<String, Boolean>>();
            prefixes.add(new AbstractMap.SimpleEntry<String, Boolean>(urlPrefix, true));
            requireConfigJson = RequireJS.generateSetupJson(prefixes);
        }
        return requireConfigJson;
    }

    public static synchronized Map<String, ObjectNode> getSetupJson(String cdnPrefix, String urlPrefix) {
        if (requireConfigJsonCdn == null) {
            ArrayList<Map.Entry<String, Boolean>> prefixes = new ArrayList<Map.Entry<String, Boolean>>();
            prefixes.add(new AbstractMap.SimpleEntry<String, Boolean>(cdnPrefix, true));
            prefixes.add(new AbstractMap.SimpleEntry<String, Boolean>(urlPrefix, true));
            requireConfigJsonCdn = RequireJS.generateSetupJson(prefixes);
        }
        return requireConfigJsonCdn;
    }

    public static Map<String, ObjectNode> generateSetupJson(List<Map.Entry<String, Boolean>> prefixes) {
        Map webJars = new WebJarAssetLocator().getWebJars();
        HashMap<String, ObjectNode> jsonConfigs = new HashMap<String, ObjectNode>();
        for (Map.Entry<String, String> entry : webJars.entrySet()) {
            jsonConfigs.put((String)entry.getKey(), RequireJS.getWebJarSetupJson(entry, prefixes));
        }
        return jsonConfigs;
    }

    private static ObjectNode getWebJarSetupJson(Map.Entry<String, String> webJar, List<Map.Entry<String, Boolean>> prefixes) {
        if (RequireJS.class.getClassLoader().getResource("META-INF/maven/org.webjars.npm/" + webJar.getKey() + "/pom.xml") != null) {
            return RequireJS.getNpmWebJarRequireJsConfig(webJar, prefixes);
        }
        if (RequireJS.class.getClassLoader().getResource("META-INF/maven/org.webjars.bower/" + webJar.getKey() + "/pom.xml") != null) {
            return RequireJS.getBowerWebJarRequireJsConfig(webJar, prefixes);
        }
        if (RequireJS.class.getClassLoader().getResource("META-INF/maven/org.webjars/" + webJar.getKey() + "/pom.xml") != null) {
            return RequireJS.getWebJarRequireJsConfig(webJar, prefixes);
        }
        return null;
    }

    public static ObjectNode getWebJarRequireJsConfig(Map.Entry<String, String> webJar, List<Map.Entry<String, Boolean>> prefixes) {
        ObjectNode webJarRequireJsNode;
        block19: {
            String rawRequireJsConfig = RequireJS.getRawWebJarRequireJsConfig(webJar);
            ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            webJarRequireJsNode = mapper.createObjectNode();
            try {
                JsonNode maybeRequireJsConfig = mapper.readTree(rawRequireJsConfig);
                if (maybeRequireJsConfig != null && maybeRequireJsConfig.isObject()) {
                    webJarRequireJsNode = (ObjectNode)maybeRequireJsConfig;
                    if (webJarRequireJsNode.isObject()) {
                        ObjectNode pathsNode = (ObjectNode)webJarRequireJsNode.get("paths");
                        ObjectNode newPaths = mapper.createObjectNode();
                        if (pathsNode != null) {
                            Iterator paths = pathsNode.fields();
                            while (paths.hasNext()) {
                                Map.Entry pathNode = (Map.Entry)paths.next();
                                String originalPath = null;
                                if (((JsonNode)pathNode.getValue()).isArray()) {
                                    ArrayNode nodePaths = (ArrayNode)pathNode.getValue();
                                    originalPath = nodePaths.get(0).asText();
                                } else if (((JsonNode)pathNode.getValue()).isTextual()) {
                                    TextNode nodePath = (TextNode)pathNode.getValue();
                                    originalPath = nodePath.textValue();
                                }
                                if (originalPath != null) {
                                    ArrayNode newPathsNode = newPaths.putArray((String)pathNode.getKey());
                                    for (Map.Entry<String, Boolean> prefix : prefixes) {
                                        String newPath = prefix.getKey() + webJar.getKey();
                                        if (prefix.getValue().booleanValue()) {
                                            newPath = newPath + "/" + webJar.getValue();
                                        }
                                        newPath = newPath + "/" + originalPath;
                                        newPathsNode.add(newPath);
                                    }
                                    newPathsNode.add(originalPath);
                                    continue;
                                }
                                log.error("Strange... The path could not be parsed.  Here is what was provided: " + ((JsonNode)pathNode.getValue()).toString());
                            }
                        }
                        webJarRequireJsNode.replace("paths", (JsonNode)newPaths);
                        ArrayNode packagesNode = webJarRequireJsNode.withArray("packages");
                        ArrayNode newPackages = mapper.createArrayNode();
                        if (packagesNode != null) {
                            for (JsonNode packageJson : packagesNode) {
                                String originalLocation = packageJson.get("location").textValue();
                                if (prefixes.size() > 0) {
                                    Map.Entry<String, Boolean> prefix;
                                    prefix = prefixes.get(prefixes.size() - 1);
                                    String newLocation = prefix.getKey() + webJar.getKey();
                                    if (prefix.getValue().booleanValue()) {
                                        newLocation = newLocation + "/" + webJar.getValue();
                                    }
                                    newLocation = newLocation + "/" + originalLocation;
                                    ((ObjectNode)packageJson).put("location", newLocation);
                                }
                                newPackages.add(packageJson);
                            }
                        }
                        webJarRequireJsNode.replace("packages", (JsonNode)newPackages);
                    }
                } else if (rawRequireJsConfig.length() > 0) {
                    log.error(RequireJS.requireJsConfigErrorMessage(webJar));
                } else {
                    log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
                }
            }
            catch (IOException e) {
                log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
                if (rawRequireJsConfig.length() <= 0) break block19;
                log.error(e.getMessage());
            }
        }
        return webJarRequireJsNode;
    }

    public static ObjectNode getBowerWebJarRequireJsConfig(Map.Entry<String, String> webJar, List<Map.Entry<String, Boolean>> prefixes) {
        String bowerJsonPath = "META-INF/resources/webjars/" + webJar.getKey() + "/" + webJar.getValue() + "/bower.json";
        return RequireJS.getWebJarRequireJsConfigFromMainConfig(webJar, prefixes, bowerJsonPath);
    }

    public static ObjectNode getNpmWebJarRequireJsConfig(Map.Entry<String, String> webJar, List<Map.Entry<String, Boolean>> prefixes) {
        String packageJsonPath = "META-INF/resources/webjars/" + webJar.getKey() + "/" + webJar.getValue() + "/package.json";
        return RequireJS.getWebJarRequireJsConfigFromMainConfig(webJar, prefixes, packageJsonPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectNode getWebJarRequireJsConfigFromMainConfig(Map.Entry<String, String> webJar, List<Map.Entry<String, Boolean>> prefixes, String path) {
        InputStream inputStream = RequireJS.class.getClassLoader().getResourceAsStream(path);
        if (inputStream != null) {
            try {
                ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
                ObjectNode requireConfig = mapper.createObjectNode();
                ObjectNode requireConfigPaths = requireConfig.putObject("paths");
                JsonNode jsonNode = mapper.readTree(inputStream);
                String name = jsonNode.get("name").asText();
                String requireFriendlyName = name.replaceAll("\\.", "-");
                JsonNode mainJs = jsonNode.get("main");
                if (mainJs != null) {
                    if (mainJs.getNodeType() == JsonNodeType.STRING) {
                        String main = mainJs.asText();
                        requireConfigPaths.set(requireFriendlyName, RequireJS.mainJsToPathJson(webJar, main, prefixes));
                    } else if (mainJs.getNodeType() == JsonNodeType.ARRAY) {
                        ArrayList<String> mainList = new ArrayList<String>();
                        for (JsonNode mainJsonNode : mainJs) {
                            mainList.add(mainJsonNode.asText());
                        }
                        String main = RequireJS.getBowerBestMatchFromMainArray(mainList, name);
                        requireConfigPaths.set(requireFriendlyName, RequireJS.mainJsToPathJson(webJar, main, prefixes));
                    }
                } else if (RequireJS.hasIndexFile("META-INF/resources/webjars/" + webJar.getKey() + "/" + webJar.getValue() + "/index.js")) {
                    requireConfigPaths.set(requireFriendlyName, RequireJS.mainJsToPathJson(webJar, "index.js", prefixes));
                } else {
                    throw new IllegalArgumentException("no 'main' nor 'index.js' file; cannot generate a config");
                }
                ObjectNode objectNode = requireConfig;
                return objectNode;
            }
            catch (IOException e) {
                log.warn("Could not create the RequireJS config for the " + webJar.getKey() + " " + webJar.getValue() + " WebJar from " + path + "\nError: " + e.getMessage() + "\nPlease file a bug at: http://github.com/webjars/webjars-locator/issues/new");
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not create the RequireJS config for the " + webJar.getKey() + " " + webJar.getValue() + " WebJar from " + path + "\nThere was not enough information in the package metadata to do so.\nError: " + e.getMessage() + "\nIf you think you have received this message in error, please file a bug at: http://github.com/webjars/webjars-locator/issues/new");
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasIndexFile(String path) {
        InputStream resourceAsStream = RequireJS.class.getClassLoader().getResourceAsStream(path);
        try {
            boolean bl = resourceAsStream != null;
            return bl;
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getBowerBestMatchFromMainArray(ArrayList<String> items, String name) {
        if (items.size() == 1) {
            return items.get(0);
        }
        ArrayList<Object> filteredList = new ArrayList();
        for (String item : items) {
            if (!item.toLowerCase().endsWith(".js")) continue;
            filteredList.add(item);
        }
        if (filteredList.size() == 0) {
            filteredList = items;
        }
        final HashMap distanceMap = new HashMap();
        final String nameForComparisons = name.toLowerCase();
        Collections.sort(filteredList, new Comparator<String>(){

            Integer getDistance(String value) {
                int distance;
                if (distanceMap.containsKey(value = value.toLowerCase())) {
                    distance = (Integer)distanceMap.get(value);
                } else {
                    distance = StringUtils.getLevenshteinDistance((CharSequence)nameForComparisons, (CharSequence)value);
                    distanceMap.put(value, distance);
                }
                return distance;
            }

            @Override
            public int compare(String o1, String o2) {
                return this.getDistance(o1).compareTo(this.getDistance(o2));
            }
        });
        return (String)filteredList.get(0);
    }

    private static JsonNode mainJsToPathJson(Map.Entry<String, String> webJar, String main, List<Map.Entry<String, Boolean>> prefixes) {
        String requireJsStyleMain = main;
        if (main.endsWith(".js")) {
            requireJsStyleMain = main.substring(0, main.lastIndexOf(".js"));
        }
        if (requireJsStyleMain.startsWith("./")) {
            requireJsStyleMain = requireJsStyleMain.substring(2);
        }
        String unprefixedMain = webJar.getKey() + "/" + webJar.getValue() + "/" + requireJsStyleMain;
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        for (Map.Entry<String, Boolean> prefix : prefixes) {
            arrayNode.add(prefix.getKey() + unprefixedMain);
        }
        return arrayNode;
    }

    private static String requireJsConfigErrorMessage(Map.Entry<String, String> webJar) {
        return "Could not read WebJar RequireJS config for: " + webJar.getKey() + " " + webJar.getValue() + "\nPlease file a bug at: http://github.com/webjars/" + webJar.getKey() + "/issues/new";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRawWebJarRequireJsConfig(Map.Entry<String, String> webJar) {
        String filename = "META-INF/maven/org.webjars/" + webJar.getKey() + "/pom.xml";
        InputStream inputStream = RequireJS.class.getClassLoader().getResourceAsStream(filename);
        if (inputStream != null) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(inputStream);
                doc.getDocumentElement().normalize();
                NodeList propertiesNodes = doc.getElementsByTagName("properties");
                for (int i = 0; i < propertiesNodes.getLength(); ++i) {
                    NodeList propertyNodes = propertiesNodes.item(i).getChildNodes();
                    for (int j = 0; j < propertyNodes.getLength(); ++j) {
                        Node node = propertyNodes.item(j);
                        if (!node.getNodeName().equals("requirejs")) continue;
                        String string = node.getTextContent();
                        return string;
                    }
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            log.warn(RequireJS.requireJsConfigErrorMessage(webJar));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getWebJarConfig(Map.Entry<String, String> webJar) {
        String webJarConfig = "";
        String filename = "META-INF/resources/webjars/" + webJar.getKey() + "/" + webJar.getValue() + "/webjars-requirejs.js";
        InputStream inputStream = RequireJS.class.getClassLoader().getResourceAsStream(filename);
        if (inputStream != null) {
            log.warn("The " + webJar.getKey() + " " + webJar.getValue() + " WebJar is using the legacy RequireJS config.\nPlease try a new version of the WebJar or file or file an issue at:\nhttp://github.com/webjars/" + webJar.getKey() + "/issues/new");
            StringBuilder webJarConfigBuilder = new StringBuilder("// WebJar config for " + webJar.getKey() + "\n");
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    webJarConfigBuilder.append(line).append("\n");
                }
                webJarConfig = webJarConfigBuilder.toString();
            }
            catch (IOException e) {
                log.warn(filename + " could not be read.");
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return webJarConfig;
    }
}

