/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.exceptions;

import java.util.Map;
import org.fao.oaipmh.OaiPmh;
import org.fao.oaipmh.exceptions.BadArgumentException;
import org.fao.oaipmh.exceptions.BadResumptionTokenException;
import org.fao.oaipmh.exceptions.BadVerbException;
import org.fao.oaipmh.exceptions.CannotDisseminateFormatException;
import org.fao.oaipmh.exceptions.IdDoesNotExistException;
import org.fao.oaipmh.exceptions.NoMetadataFormatsException;
import org.fao.oaipmh.exceptions.NoRecordsMatchException;
import org.fao.oaipmh.exceptions.NoSetHierarchyException;
import org.fao.oaipmh.util.Lib;
import org.jdom.Element;

public class OaiPmhException
extends Exception {
    protected static final String BAD_ARGUMENT = "badArgument";
    protected static final String BAD_RESUMPTION_TOKEN = "badResumptionToken";
    protected static final String BAD_VERB = "badVerb";
    protected static final String CANNOT_DISSEMINATE_FORMAT = "cannotDisseminateFormat";
    protected static final String ID_DOES_NOT_EXIST = "idDoesNotExist";
    protected static final String NO_RECORDS_MATCH = "noRecordsMatch";
    protected static final String NO_METADATA_FORMATS = "noMetadataFormats";
    protected static final String NO_SET_HIERARCHY = "noSetHierarchy";
    private static final long serialVersionUID = -370658366099038395L;
    private String code;
    private Element response;

    public OaiPmhException(String code, String message) {
        this(code, message, null);
    }

    public OaiPmhException(String code, String message, Element response) {
        super(message);
        this.code = code;
        this.response = response;
    }

    public static Element marshal(OaiPmhException e, String reqUrl, Map<String, String> reqParams) {
        Element err = new Element("error", OaiPmh.Namespaces.OAI_PMH);
        err.setText(e.getMessage());
        err.setAttribute("code", e.getCode());
        Element root = Lib.createOaiRoot(reqUrl, reqParams, err);
        return root;
    }

    public static void unmarshal(Element response) throws OaiPmhException {
        Element error = response.getChild("error", OaiPmh.Namespaces.OAI_PMH);
        if (error == null) {
            return;
        }
        String code = error.getAttributeValue("code");
        String msg = error.getText();
        if (code.equals(BAD_ARGUMENT)) {
            throw new BadArgumentException(msg, response);
        }
        if (code.equals(BAD_RESUMPTION_TOKEN)) {
            throw new BadResumptionTokenException(msg, response);
        }
        if (code.equals(BAD_VERB)) {
            throw new BadVerbException(msg, response);
        }
        if (code.equals(CANNOT_DISSEMINATE_FORMAT)) {
            throw new CannotDisseminateFormatException(msg, response);
        }
        if (code.equals(ID_DOES_NOT_EXIST)) {
            throw new IdDoesNotExistException(msg, response);
        }
        if (code.equals(NO_RECORDS_MATCH)) {
            throw new NoRecordsMatchException(msg, response);
        }
        if (code.equals(NO_METADATA_FORMATS)) {
            throw new NoMetadataFormatsException(msg, response);
        }
        if (code.equals(NO_SET_HIERARCHY)) {
            throw new NoSetHierarchyException(msg, response);
        }
        throw new RuntimeException("Unknown error code : " + code);
    }

    public String getCode() {
        return this.code;
    }

    public Element getResponse() {
        return this.response;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": code=" + this.code + ", message=" + this.getMessage();
    }
}

