/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbNodesCurrent;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

public class SVNWCDbCollectTargets
extends SVNWCDbNodesCurrent {
    private SVNDepth depth;
    private File target;
    private Collection<String> changelists;
    private SVNSqlJetSelectStatement selectChangelist;
    private Set<String> receivedPaths;

    public SVNWCDbCollectTargets(SVNSqlJetDb sDb, long wcId, File target, SVNDepth depth, Collection<String> changelists) throws SVNException {
        super(sDb);
        this.setDepth(depth);
        this.setTarget(target);
        this.setChangelists(changelists);
        if (this.getChangelists() != null && !this.getChangelists().isEmpty()) {
            this.selectChangelist = new SVNSqlJetSelectStatement(sDb, SVNWCDbSchema.ACTUAL_NODE);
        }
        if (this.getDepth() == SVNDepth.FILES || this.getDepth() == SVNDepth.IMMEDIATES) {
            this.setIndexName(SVNWCDbSchema.NODES__Indices.I_NODES_PARENT.toString());
            this.receivedPaths = new HashSet<String>();
        }
        if (this.getDepth() == SVNDepth.FILES || this.getDepth() == SVNDepth.IMMEDIATES || this.getDepth() == SVNDepth.EMPTY) {
            this.bindf("is", wcId, this.getTarget());
        } else {
            this.bindf("i", wcId);
        }
    }

    @Override
    protected boolean isFilterPassed() throws SVNException {
        if (this.getDepth() == SVNDepth.FILES || this.getDepth() == SVNDepth.IMMEDIATES ? !this.receivedPaths.add(this.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath)) : !super.isFilterPassed()) {
            return false;
        }
        if (this.getDepth() == SVNDepth.FILES) {
            String kind = this.getColumnString(SVNWCDbSchema.NODES__Fields.kind);
            return "file".equals(kind) && this.matchesChangelist();
        }
        if (this.getDepth() == SVNDepth.INFINITY) {
            String targetPath = SVNFileUtil.getFilePath(this.getTarget());
            if ("".equals(targetPath)) {
                return this.matchesChangelist();
            }
            String rowPath = this.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath);
            return (targetPath.equals(rowPath) || rowPath.startsWith(targetPath + '/')) && this.matchesChangelist();
        }
        return this.matchesChangelist();
    }

    private boolean matchesChangelist() throws SVNException {
        if (this.getChangelists() == null || this.getChangelists().isEmpty()) {
            return true;
        }
        try {
            this.selectChangelist.bindf("is", this.getColumnLong(SVNWCDbSchema.NODES__Fields.wc_id), this.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
            if (this.selectChangelist.next()) {
                boolean bl = this.changelists.contains(this.selectChangelist.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.changelist));
                return bl;
            }
        }
        finally {
            this.selectChangelist.reset();
        }
        return false;
    }

    private File getTarget() {
        return this.target;
    }

    private SVNDepth getDepth() {
        return this.depth;
    }

    private Collection<String> getChangelists() {
        return this.changelists;
    }

    private void setDepth(SVNDepth depth) {
        this.depth = depth;
    }

    private void setTarget(File target) {
        this.target = target;
    }

    private void setChangelists(Collection<String> changelists) {
        this.changelists = changelists == null ? changelists : new HashSet(changelists);
    }
}

