/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.IntCollection;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.hash.DefaultIntHashFunction;
import bak.pcj.map.DoubleKeyIntMap;
import bak.pcj.map.DoubleKeyIntMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractDoubleKeyIntMap
implements DoubleKeyIntMap {
    protected AbstractDoubleKeyIntMap() {
    }

    public void clear() {
        DoubleKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public int remove(double key) {
        DoubleKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            int value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultInt();
    }

    public void putAll(DoubleKeyIntMap map) {
        DoubleKeyIntMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(double key) {
        DoubleKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public int get(double key) {
        DoubleKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultInt();
    }

    public boolean containsValue(int value) {
        DoubleKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleKeyIntMap)) {
            return false;
        }
        DoubleKeyIntMap map = (DoubleKeyIntMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        DoubleKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            double k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        DoubleKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultDoubleHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultIntHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        DoubleKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public int tget(double key) {
        int value = this.get(key);
        if (value == MapDefaults.defaultInt() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        DoubleKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract IntCollection values();

    public abstract int put(double var1, int var3);

    public abstract int lget();

    public abstract DoubleSet keySet();

    public abstract DoubleKeyIntMapIterator entries();
}

