/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.CharCollection;
import bak.pcj.hash.DefaultByteHashFunction;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.map.ByteKeyCharMap;
import bak.pcj.map.ByteKeyCharMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractByteKeyCharMap
implements ByteKeyCharMap {
    protected AbstractByteKeyCharMap() {
    }

    public void clear() {
        ByteKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public char remove(byte key) {
        ByteKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            char value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultChar();
    }

    public void putAll(ByteKeyCharMap map) {
        ByteKeyCharMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(byte key) {
        ByteKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public char get(byte key) {
        ByteKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultChar();
    }

    public boolean containsValue(char value) {
        ByteKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteKeyCharMap)) {
            return false;
        }
        ByteKeyCharMap map = (ByteKeyCharMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        ByteKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            byte k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        ByteKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultByteHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultCharHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        ByteKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public char tget(byte key) {
        char value = this.get(key);
        if (value == MapDefaults.defaultChar() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        ByteKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract CharCollection values();

    public abstract char put(byte var1, char var2);

    public abstract char lget();

    public abstract ByteSet keySet();

    public abstract ByteKeyCharMapIterator entries();
}

