/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.ByteCollection;
import bak.pcj.hash.DefaultByteHashFunction;
import bak.pcj.map.ByteKeyByteMap;
import bak.pcj.map.ByteKeyByteMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractByteKeyByteMap
implements ByteKeyByteMap {
    protected AbstractByteKeyByteMap() {
    }

    public void clear() {
        ByteKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public byte remove(byte key) {
        ByteKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            byte value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultByte();
    }

    public void putAll(ByteKeyByteMap map) {
        ByteKeyByteMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(byte key) {
        ByteKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public byte get(byte key) {
        ByteKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultByte();
    }

    public boolean containsValue(byte value) {
        ByteKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteKeyByteMap)) {
            return false;
        }
        ByteKeyByteMap map = (ByteKeyByteMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        ByteKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            byte k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        ByteKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultByteHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultByteHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        ByteKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public byte tget(byte key) {
        byte value = this.get(key);
        if (value == MapDefaults.defaultByte() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        ByteKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract ByteCollection values();

    public abstract byte put(byte var1, byte var2);

    public abstract byte lget();

    public abstract ByteSet keySet();

    public abstract ByteKeyByteMapIterator entries();
}

