/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ShortCollection;
import bak.pcj.adapter.CollectionToShortCollectionAdapter;
import bak.pcj.adapter.SetToLongSetAdapter;
import bak.pcj.map.AbstractLongKeyShortMap;
import bak.pcj.map.LongKeyShortMap;
import bak.pcj.map.LongKeyShortMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToLongKeyShortMapAdapter
extends AbstractLongKeyShortMap
implements LongKeyShortMap {
    protected Map map;
    protected Short lastValue;

    public MapToLongKeyShortMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToLongKeyShortMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(long key) {
        this.lastValue = (Short)this.map.get(new Long(key));
        return this.lastValue != null;
    }

    public boolean containsValue(short value) {
        return this.map.containsValue(new Short(value));
    }

    public LongKeyShortMapIterator entries() {
        return new LongKeyShortMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToLongKeyShortMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public long getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Long)this.lastEntry.getKey();
            }

            public short getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public short get(long key) {
        Short value = (Short)this.map.get(new Long(key));
        return value == null ? MapDefaults.defaultShort() : value;
    }

    public LongSet keySet() {
        return new SetToLongSetAdapter(this.map.keySet());
    }

    public short lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public short put(long key, short value) {
        Short oldValue = this.map.put(new Long(key), new Short(value));
        return oldValue == null ? MapDefaults.defaultShort() : oldValue;
    }

    public short remove(long key) {
        Short value = (Short)this.map.remove(new Long(key));
        return value == null ? MapDefaults.defaultShort() : value;
    }

    public int size() {
        return this.map.size();
    }

    public ShortCollection values() {
        return new CollectionToShortCollectionAdapter(this.map.values());
    }

    public short tget(long key) {
        Short value = (Short)this.map.get(new Long(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isLongKeyShortAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

