/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.AbstractBooleanCollection;
import bak.pcj.Adapter;
import bak.pcj.BooleanIterator;
import bak.pcj.adapter.IteratorToBooleanIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.Collection;

public class CollectionToBooleanCollectionAdapter
extends AbstractBooleanCollection {
    protected Collection collection;

    public CollectionToBooleanCollectionAdapter(Collection collection) {
        this(collection, false);
    }

    public CollectionToBooleanCollectionAdapter(Collection collection, boolean validate) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(boolean v) {
        return this.collection.add(new Boolean(v));
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(boolean v) {
        return this.collection.contains(new Boolean(v));
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public BooleanIterator iterator() {
        return new IteratorToBooleanIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(boolean v) {
        return this.collection.remove(new Boolean(v));
    }

    public int size() {
        return this.collection.size();
    }

    public boolean validate() {
        return Adapter.isBooleanAdaptable(this.collection);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("collection");
        }
    }
}

