/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.FloatCollection;
import bak.pcj.FloatIterator;
import bak.pcj.util.Exceptions;

public class SynchronizedFloatCollection
implements FloatCollection {
    protected FloatCollection collection;
    protected Object m;

    public SynchronizedFloatCollection(FloatCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = c;
        this.m = this;
    }

    public boolean add(float v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.add(v);
            return bl;
        }
    }

    public boolean addAll(FloatCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.addAll(c);
            return bl;
        }
    }

    public void clear() {
        Object object = this.m;
        synchronized (object) {
            this.collection.clear();
        }
    }

    public boolean contains(float v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.contains(v);
            return bl;
        }
    }

    public boolean containsAll(FloatCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.containsAll(c);
            return bl;
        }
    }

    public boolean equals(Object obj) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.equals(obj);
            return bl;
        }
    }

    public int hashCode() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.hashCode();
            return n;
        }
    }

    public boolean isEmpty() {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.isEmpty();
            return bl;
        }
    }

    public FloatIterator iterator() {
        Object object = this.m;
        synchronized (object) {
            FloatIterator floatIterator = this.collection.iterator();
            return floatIterator;
        }
    }

    public boolean remove(float v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.remove(v);
            return bl;
        }
    }

    public boolean removeAll(FloatCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.removeAll(c);
            return bl;
        }
    }

    public boolean retainAll(FloatCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.retainAll(c);
            return bl;
        }
    }

    public int size() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.size();
            return n;
        }
    }

    public float[] toArray() {
        Object object = this.m;
        synchronized (object) {
            float[] fArray = this.collection.toArray();
            return fArray;
        }
    }

    public float[] toArray(float[] a) {
        Object object = this.m;
        synchronized (object) {
            float[] fArray = this.collection.toArray(a);
            return fArray;
        }
    }

    public void trimToSize() {
        Object object = this.m;
        synchronized (object) {
            this.collection.trimToSize();
        }
    }
}

