/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.admin;

import java.text.NumberFormat;
import org.openrdf.sesame.admin.AdminListener;

public class StatusReporter
extends Thread {
    protected long _interval;
    protected long _startTime;
    protected long _endTime;
    protected long _wakeUpTime;
    protected boolean _continueRunning;
    protected int _statementCount;
    protected AdminListener _report;
    protected NumberFormat _nf;

    public StatusReporter(long interval, AdminListener report) {
        this.setDaemon(true);
        this._interval = interval;
        this._report = report;
        this.setDaemon(true);
        this._nf = NumberFormat.getInstance();
        this._endTime = -1L;
        this._startTime = -1L;
        this._continueRunning = true;
    }

    public void run() {
        this._statementCount = 0;
        this._startTime = System.currentTimeMillis();
        this._endTime = -1L;
        this._wakeUpTime = this._startTime + this._interval;
        while (this._continueRunning) {
            long delay = this._wakeUpTime - System.currentTimeMillis();
            if ((double)delay <= 0.0) {
                this._writeStatus();
                this._wakeUpTime += this._interval;
                continue;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void stopRunning() {
        this._continueRunning = false;
        this._endTime = System.currentTimeMillis();
        this._writeStatus();
        this.interrupt();
    }

    public void statementAdded() {
        ++this._statementCount;
    }

    public int getStatementCount() {
        return this._statementCount;
    }

    public long getRunningTime() {
        if (this._startTime == -1L) {
            return 0L;
        }
        if (this._endTime > 0L) {
            return this._endTime - this._startTime;
        }
        return System.currentTimeMillis() - this._startTime;
    }

    protected void _writeStatus() {
        StringBuffer msg = new StringBuffer(64);
        msg.append("Processed ");
        msg.append(this._nf.format(this._statementCount));
        msg.append(" statements in ");
        msg.append(this.getRunningTime() / 1000L);
        msg.append(" seconds");
        if (this._endTime < 0L) {
            msg.append("; processing continues");
        }
        this._report.status(msg.toString(), -1, -1);
    }
}

