/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.RecordConversion;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.util.RecordConversion.FragmentTransformationException;
import org.jzkit.search.util.RecordConversion.FragmentTransformer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;

public abstract class XSLFragmentTransformer
extends FragmentTransformer {
    protected Templates t = null;
    protected static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    protected static Log log = LogFactory.getLog(XSLFragmentTransformer.class);
    protected String the_path = null;
    protected long datestamp = 0L;

    public XSLFragmentTransformer(String from, String to, Map props, Map context, ApplicationContext ctx) throws TransformerConfigurationException {
        super(from, to, props, context, ctx);
        this.the_path = (String)props.get("Sheet");
        this.reloadStylesheet();
    }

    public abstract Object transform(Document var1, Map var2) throws FragmentTransformationException;

    public void performTransformation(Source source, Result result, Map trans_properties) {
        try {
            this.checkStylesheetDatestamp();
            Transformer trans = this.t.newTransformer();
            trans.clearParameters();
            if (trans_properties != null) {
                Set entries = trans_properties.entrySet();
                for (Map.Entry e : entries) {
                    trans.setParameter(e.getKey().toString(), e.getValue().toString());
                }
            }
            trans.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            log.warn((Object)("TransformerConfigurationException exception finding template " + this.the_path), (Throwable)tce);
        }
        catch (TransformerException te) {
            log.warn((Object)("TransformerException General exception finding template " + this.the_path), (Throwable)te);
        }
        catch (Exception e) {
            log.warn((Object)("General exception finding template " + this.the_path), (Throwable)e);
        }
    }

    private void reloadStylesheet() throws TransformerConfigurationException {
        log.debug((Object)"XSLFragmentTransformer::reloadStylesheet()");
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (this.ctx == null) {
                throw new RuntimeException("Application Context Is Null. Cannot resolve resources");
            }
            Resource r = this.ctx.getResource(this.the_path);
            if (r != null && r.exists()) {
                URL path_url = r.getURL();
                URLConnection conn = path_url.openConnection();
                this.datestamp = conn.getDate();
                log.debug((Object)("get template for " + this.the_path + " url:" + path_url + " datestamp=" + this.datestamp));
                this.t = tFactory.newTemplates(new StreamSource(conn.getInputStream()));
            } else {
                log.error((Object)("Unable to resolve URL for " + this.the_path));
            }
        }
        catch (IOException ioe) {
            log.warn((Object)"Problem with XSL mapping", (Throwable)ioe);
            throw new RuntimeException("Unable to locate mapping: " + this.the_path);
        }
        catch (TransformerConfigurationException tce) {
            log.warn((Object)"Problem with XSL mapping", (Throwable)tce);
            throw tce;
        }
    }

    private void checkStylesheetDatestamp() {
        try {
            URL path_url = XSLFragmentTransformer.class.getResource(this.the_path);
            URLConnection conn = path_url.openConnection();
            long current_date = conn.getDate();
            if (current_date != this.datestamp) {
                log.debug((Object)"Detected change of xsl stylesheet, reloading");
                this.reloadStylesheet();
            }
        }
        catch (IOException ioe) {
            log.warn((Object)("Problem with XSL mapping - " + this.the_path), (Throwable)ioe);
        }
        catch (TransformerConfigurationException tce) {
            log.warn((Object)("Problem with XSL mapping - " + this.the_path), (Throwable)tce);
        }
    }
}

