/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.resolver.xml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.xsd.Schemas;

public final class AppSchemaXSDRegistry
implements XSDSchemaLocator {
    private static volatile AppSchemaXSDRegistry theXSDRegistry;
    private Map<String, XSDSchema> schemaRegistry = new HashMap<String, XSDSchema>();

    private AppSchemaXSDRegistry() {
    }

    public static AppSchemaXSDRegistry getInstance() {
        if (theXSDRegistry == null) {
            theXSDRegistry = new AppSchemaXSDRegistry();
        }
        return theXSDRegistry;
    }

    public synchronized void register(XSDSchema schema) {
        this.schemaRegistry.put(schema.getSchemaLocation(), schema);
    }

    public synchronized XSDSchema lookUp(String schemaLocation) {
        return this.schemaRegistry.get(schemaLocation);
    }

    public synchronized void dispose() {
        for (XSDSchema schema : this.schemaRegistry.values()) {
            Schemas.dispose((XSDSchema)schema);
        }
        this.schemaRegistry.clear();
    }

    public synchronized XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
        if (xsdSchema != null) {
            ResourceSet resourceSet = xsdSchema.eResource().getResourceSet();
            Resource resolvedResource = resourceSet.getResource(URI.createURI((String)(resolvedSchemaLocationURI == null ? "" : resolvedSchemaLocationURI)), false);
            if (resolvedResource != null && resolvedResource instanceof XSDResourceImpl) {
                return ((XSDResourceImpl)resolvedResource).getSchema();
            }
            XSDSchema schema = this.lookUp(resolvedSchemaLocationURI);
            if (schema == null) {
                try {
                    schema = Schemas.parse((String)resolvedSchemaLocationURI, (ResourceSet)resourceSet, null);
                    this.register(schema);
                }
                catch (IOException e) {
                    schema = null;
                }
            }
            return schema;
        }
        return this.lookUp(resolvedSchemaLocationURI);
    }
}

