/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v2_0.bindings;

import java.util.Enumeration;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class CopyingHandler
extends DefaultHandler {
    protected StringBuffer buffer;
    protected NamespaceSupport namespaceContext;
    protected int root = 0;

    public CopyingHandler() {
        this(null);
    }

    public CopyingHandler(NamespaceSupport namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
            ++this.root;
        }
        this.buffer.append("<");
        if (qName.startsWith(":")) {
            this.buffer.append(localName);
        } else {
            this.buffer.append(qName);
        }
        HashSet<String> xmlnsAttributes = new HashSet<String>();
        if (attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeName = attributes.getQName(i);
                if (attributeName.startsWith("xmlns")) {
                    xmlnsAttributes.add(attributeName);
                }
                this.buffer.append(" ").append(attributeName).append("=\"").append(attributes.getValue(i)).append("\"");
            }
        }
        if (this.root > 0) {
            if (this.namespaceContext != null) {
                HashSet<String> mappedPrefixes = new HashSet<String>();
                Enumeration<String> e = this.namespaceContext.getPrefixes();
                while (e.hasMoreElements()) {
                    String prefix = e.nextElement();
                    if (mappedPrefixes.contains(prefix)) continue;
                    if ("".equals(prefix)) {
                        if (xmlnsAttributes.contains("xmlns")) continue;
                        this.buffer.append(" xmlns");
                    } else {
                        if (xmlnsAttributes.contains("xmlns:" + prefix)) continue;
                        this.buffer.append(" xmlns:").append(prefix);
                    }
                    this.buffer.append("=\"").append(this.namespaceContext.getURI(prefix)).append("\"");
                    mappedPrefixes.add(prefix);
                }
            }
            --this.root;
        }
        this.buffer.append(">");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
            ++this.root;
        }
        this.buffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append("</").append(qName).append(">");
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.buffer = null;
    }
}

