/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.modca.AbstractEnvironmentGroup;
import org.apache.fop.afp.modca.AbstractStructuredObject;
import org.apache.fop.afp.modca.AbstractTripletStructuredObject;
import org.apache.fop.afp.modca.MapCodedFont;
import org.apache.fop.afp.modca.MapDataResource;
import org.apache.fop.afp.modca.MapPageSegment;
import org.apache.fop.afp.modca.MaximumSizeExceededException;
import org.apache.fop.afp.modca.ObjectAreaDescriptor;
import org.apache.fop.afp.modca.ObjectAreaPosition;
import org.apache.fop.afp.modca.PageDescriptor;
import org.apache.fop.afp.modca.PresentationTextDescriptor;
import org.apache.fop.afp.modca.triplets.AbstractTriplet;
import org.apache.fop.afp.modca.triplets.EncodingTriplet;
import org.apache.fop.afp.util.BinaryUtils;
import org.apache.fop.fonts.FontType;
import org.apache.fop.render.afp.AFPFontConfig;

public final class ActiveEnvironmentGroup
extends AbstractEnvironmentGroup {
    private final List<AbstractStructuredObject> mapCodedFonts = new ArrayList<AbstractStructuredObject>();
    private List mapPageSegments;
    private ObjectAreaDescriptor objectAreaDescriptor;
    private ObjectAreaPosition objectAreaPosition;
    private PresentationTextDescriptor presentationTextDataDescriptor;
    private PageDescriptor pageDescriptor;
    private final Factory factory;
    private MapDataResource mdr;
    private MapCodedFont mapCodedFont;

    public ActiveEnvironmentGroup(Factory factory, String name, int width, int height, int widthRes, int heightRes) {
        super(name);
        this.factory = factory;
        this.pageDescriptor = factory.createPageDescriptor(width, height, widthRes, heightRes);
        this.objectAreaDescriptor = factory.createObjectAreaDescriptor(width, height, widthRes, heightRes);
        this.presentationTextDataDescriptor = factory.createPresentationTextDataDescriptor(width, height, widthRes, heightRes);
    }

    public void setObjectAreaPosition(int x, int y, int rotation) {
        this.objectAreaPosition = this.factory.createObjectAreaPosition(x, y, rotation);
    }

    public PageDescriptor getPageDescriptor() {
        return this.pageDescriptor;
    }

    public PresentationTextDescriptor getPresentationTextDataDescriptor() {
        return this.presentationTextDataDescriptor;
    }

    @Override
    public void writeContent(OutputStream os) throws IOException {
        super.writeTriplets(os);
        this.writeObjects(this.mapCodedFonts, os);
        this.writeObjects(this.mapDataResources, os);
        this.writeObjects(this.mapPageOverlays, os);
        this.writeObjects(this.mapPageSegments, os);
        if (this.pageDescriptor != null) {
            this.pageDescriptor.writeToStream(os);
        }
        if (this.objectAreaDescriptor != null && this.objectAreaPosition != null) {
            this.objectAreaDescriptor.writeToStream(os);
            this.objectAreaPosition.writeToStream(os);
        }
        if (this.presentationTextDataDescriptor != null) {
            this.presentationTextDataDescriptor.writeToStream(os);
        }
    }

    @Override
    protected void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        this.copySF(data, (byte)-88, (byte)-55);
        os.write(data);
    }

    @Override
    protected void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        this.copySF(data, (byte)-87, (byte)-55);
        os.write(data);
    }

    public void createFont(int fontRef, AFPFont font, int size, int orientation) {
        if (font.getFontType() == FontType.TRUETYPE) {
            if (this.mdr == null) {
                this.mdr = this.factory.createMapDataResource();
                this.mapCodedFonts.add(this.mdr);
            }
            this.mdr.addTriplet(new EncodingTriplet(1200));
            String name = font.getFontName();
            if (((AFPFontConfig.AFPTrueTypeFont)font).getTTC() != null) {
                name = ((AFPFontConfig.AFPTrueTypeFont)font).getTTC();
            }
            this.mdr.setFullyQualifiedName((byte)-34, (byte)0, name, true);
            this.mdr.addTriplet(new FontFullyQualifiedNameTriplet((byte)fontRef));
            ActiveEnvironmentGroup.setupTruetypeMDR(this.mdr, false);
            this.mdr.addTriplet(new DataObjectFontTriplet(size / 1000));
            this.mdr.finishElement();
        } else {
            if (this.mapCodedFont == null) {
                this.mapCodedFont = this.factory.createMapCodedFont();
                this.mapCodedFonts.add(0, this.mapCodedFont);
            }
            try {
                this.mapCodedFont.addFont(fontRef, font, size, orientation);
            }
            catch (MaximumSizeExceededException msee) {
                this.mapCodedFont = this.factory.createMapCodedFont();
                this.mapCodedFonts.add(0, this.mapCodedFont);
                try {
                    this.mapCodedFont.addFont(fontRef, font, size, orientation);
                }
                catch (MaximumSizeExceededException ex) {
                    LOG.error((Object)"createFont():: resulted in a MaximumSizeExceededException");
                }
            }
        }
    }

    public static void setupTruetypeMDR(AbstractTripletStructuredObject mdr, boolean res) {
        AFPDataObjectInfo dataInfo = new AFPDataObjectInfo();
        dataInfo.setMimeType("image/x-afp+truetype");
        mdr.setObjectClassification((byte)65, dataInfo.getObjectType(), res, false, res);
    }

    public void addMapPageSegment(String name) {
        try {
            this.needMapPageSegment().addPageSegment(name);
        }
        catch (MaximumSizeExceededException e) {
            throw new IllegalStateException("Internal error: " + e.getMessage());
        }
    }

    private MapPageSegment getCurrentMapPageSegment() {
        return (MapPageSegment)this.getLastElement(this.mapPageSegments);
    }

    private MapPageSegment needMapPageSegment() {
        MapPageSegment seg;
        if (this.mapPageSegments == null) {
            this.mapPageSegments = new ArrayList();
        }
        if ((seg = this.getCurrentMapPageSegment()) == null || seg.isFull()) {
            seg = new MapPageSegment();
            this.mapPageSegments.add(seg);
        }
        return seg;
    }

    static class DataObjectFontTriplet
    extends AbstractTriplet {
        private int pointSize;

        public DataObjectFontTriplet(int size) {
            super((byte)-117);
            this.pointSize = size;
        }

        @Override
        public int getDataLength() {
            return 16;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            byte[] data = this.getData();
            data[3] = 32;
            byte[] pointSizeBytes = BinaryUtils.convert(this.pointSize * 20, 2);
            data[4] = pointSizeBytes[0];
            data[5] = pointSizeBytes[1];
            data[11] = 3;
            data[13] = 1;
            os.write(data);
        }
    }

    public static class FontFullyQualifiedNameTriplet
    extends AbstractTriplet {
        private byte fqName;

        public FontFullyQualifiedNameTriplet(byte fqName) {
            super((byte)2);
            this.fqName = fqName;
        }

        @Override
        public int getDataLength() {
            return 5;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            byte[] data = this.getData();
            data[2] = -66;
            data[3] = 0;
            data[4] = this.fqName;
            os.write(data);
        }
    }
}

