/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.LN;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoReader {
    public final LNLogEntry logEntry;
    public final LN ln;
    final long nodeId;
    public final DatabaseImpl db;
    private final DbTree dbMapTree;

    public UndoReader(EnvironmentImpl envImpl, long undoLsn, Map<DatabaseId, DatabaseImpl> undoDatabases) {
        this.logEntry = (LNLogEntry)envImpl.getLogManager().getLogEntryHandleFileNotFound(undoLsn);
        this.ln = this.logEntry.getLN();
        this.nodeId = this.ln.getNodeId();
        DatabaseId dbId = this.logEntry.getDbId();
        this.db = undoDatabases.get(dbId);
        this.ln.postFetchInit(this.db, undoLsn);
        this.dbMapTree = null;
    }

    public UndoReader(LNFileReader reader, DbTree dbMapTree) {
        this.logEntry = reader.getLogEntry();
        this.ln = reader.getLN();
        this.nodeId = this.ln.getNodeId();
        DatabaseId dbId = this.logEntry.getDbId();
        this.dbMapTree = dbMapTree;
        this.db = dbMapTree.getDb(dbId);
        this.ln.postFetchInit(this.db, reader.getLastLsn());
    }

    public void releaseDb() {
        this.dbMapTree.releaseDb(this.db);
    }

    public String toString() {
        return this.ln + " nodeId=" + this.nodeId;
    }
}

