/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConnectionPool {
    protected List _connections;
    protected String _url;
    protected String _user;
    protected String _password;
    protected boolean _checkConnections = true;
    protected long _cleaningInterval = 30000L;
    protected long _maxIdleTime = 30000L;
    protected long _maxUseTime = -1L;
    protected boolean _draining = false;
    protected PoolCleaner _cleaner;

    public ConnectionPool(String url, String user, String password) {
        this._url = url;
        this._user = user;
        this._password = password;
        this._connections = new ArrayList();
    }

    public void setCheckConnections(boolean checkConnections) {
        this._checkConnections = checkConnections;
    }

    public void setCleaningInterval(long cleaningInterval) {
        this._cleaningInterval = cleaningInterval;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public void setMaxUseTime(long maxUseTime) {
        this._maxUseTime = maxUseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        PoolConnection pc;
        if (this._draining) {
            throw new SQLException("ConnectionPool was drained.");
        }
        List list = this._connections;
        synchronized (list) {
            pc = null;
            for (int i = 0; i < this._connections.size(); ++i) {
                pc = (PoolConnection)this._connections.get(i);
                if (!pc.lease()) continue;
                if (!this._checkConnections) {
                    return pc;
                }
                boolean isHealthy = true;
                try {
                    if (pc.isClosed() && pc.getWarnings() != null) {
                        isHealthy = false;
                    }
                }
                catch (SQLException sqle) {
                    isHealthy = false;
                }
                if (isHealthy) {
                    return pc;
                }
                try {
                    pc.expire();
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
                this._connections.remove(i);
            }
        }
        Connection con = DriverManager.getConnection(this._url, this._user, this._password);
        pc = new PoolConnection(con);
        pc.lease();
        List list2 = this._connections;
        synchronized (list2) {
            this._connections.add(pc);
            if (this._cleaner == null) {
                this._cleaner = new PoolCleaner(this._cleaningInterval);
                this._cleaner.start();
            }
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpired() {
        long maxIdleDeadline = System.currentTimeMillis() - this._maxIdleTime;
        long maxUseDeadline = System.currentTimeMillis() - this._maxUseTime;
        List list = this._connections;
        synchronized (list) {
            for (int i = this._connections.size() - 1; i >= 0; --i) {
                PoolConnection pc = (PoolConnection)this._connections.get(i);
                if (!pc.inUse() && pc.getTimeClosed() < maxIdleDeadline) {
                    this._connections.remove(i);
                    try {
                        pc.expire();
                    }
                    catch (SQLException ignore) {}
                    continue;
                }
                if (this._maxUseTime < 0L || !pc.inUse() || pc.getTimeOpened() >= maxUseDeadline) continue;
                System.err.println("Warning: forced closing of a connection that has been in use too long.");
                System.err.println("Connection was acquired in:");
                pc.printStackTrace();
                System.err.println();
                this._connections.remove(i);
                try {
                    pc.expire();
                    continue;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
            }
            if (this._connections.size() == 0 && this._cleaner != null) {
                this._cleaner.halt();
                this._cleaner = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        List list = this._connections;
        synchronized (list) {
            return this._connections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        this._draining = true;
        if (this._cleaner != null) {
            this._cleaner.halt();
        }
        List list = this._connections;
        synchronized (list) {
            for (int i = this._connections.size() - 1; i >= 0; --i) {
                PoolConnection pc = (PoolConnection)this._connections.get(i);
                if (pc.inUse()) {
                    System.err.println("Warning: forced closing of a connection still in use.");
                    System.err.println("Connection was acquired in:");
                    pc.printStackTrace();
                    System.err.println();
                }
                this._connections.remove(i);
                try {
                    pc.expire();
                    continue;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
            }
        }
    }

    protected void finalize() {
        this.drain();
    }

    class PoolCleaner
    extends Thread {
        protected long _cleaningInterval;
        protected boolean _mustStop;

        public PoolCleaner(long cleaningInterval) {
            if (cleaningInterval < 0L) {
                throw new IllegalArgumentException("cleaningInterval must be >= 0");
            }
            this._mustStop = false;
            this._cleaningInterval = cleaningInterval;
            this.setDaemon(true);
        }

        public void run() {
            while (!this._mustStop) {
                try {
                    PoolCleaner.sleep(this._cleaningInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this._mustStop) break;
                ConnectionPool.this.removeExpired();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void halt() {
            this._mustStop = true;
            PoolCleaner poolCleaner = this;
            synchronized (poolCleaner) {
                this.interrupt();
            }
        }
    }

    static class PoolConnection
    implements Connection {
        protected Connection _conn;
        protected boolean _inUse;
        protected boolean _autoCommit;
        protected long _timeOpened;
        protected long _timeClosed;
        private Throwable _throwable;

        public PoolConnection(Connection conn) {
            this._conn = conn;
            this._inUse = false;
            this._autoCommit = true;
        }

        public synchronized boolean lease() {
            if (this._inUse) {
                return false;
            }
            this._inUse = true;
            this._timeOpened = System.currentTimeMillis();
            return true;
        }

        public boolean inUse() {
            return this._inUse;
        }

        public synchronized long getTimeOpened() {
            return this._timeOpened;
        }

        public synchronized long getTimeClosed() {
            return this._timeClosed;
        }

        public void expire() throws SQLException {
            this._conn.close();
            this._conn = null;
        }

        public void printStackTrace() {
            this._throwable.printStackTrace(System.err);
        }

        public synchronized void close() throws SQLException {
            if (this._inUse) {
                this._timeClosed = System.currentTimeMillis();
                this._inUse = false;
                if (!this._autoCommit) {
                    this.setAutoCommit(true);
                }
            }
        }

        public Statement createStatement() throws SQLException {
            this._throwable = new Throwable();
            return this._conn.createStatement();
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            this._throwable = new Throwable();
            return this._conn.prepareStatement(sql);
        }

        public CallableStatement prepareCall(String sql) throws SQLException {
            return this._conn.prepareCall(sql);
        }

        public String nativeSQL(String sql) throws SQLException {
            return this._conn.nativeSQL(sql);
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this._conn.setAutoCommit(autoCommit);
            this._autoCommit = this._conn.getAutoCommit();
        }

        public boolean getAutoCommit() throws SQLException {
            return this._conn.getAutoCommit();
        }

        public void commit() throws SQLException {
            this._conn.commit();
        }

        public void rollback() throws SQLException {
            this._conn.rollback();
        }

        public boolean isClosed() throws SQLException {
            return this._conn.isClosed();
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            return this._conn.getMetaData();
        }

        public void setReadOnly(boolean readOnly) throws SQLException {
            this._conn.setReadOnly(readOnly);
        }

        public boolean isReadOnly() throws SQLException {
            return this._conn.isReadOnly();
        }

        public void setCatalog(String catalog) throws SQLException {
            this._conn.setCatalog(catalog);
        }

        public String getCatalog() throws SQLException {
            return this._conn.getCatalog();
        }

        public void setTransactionIsolation(int level) throws SQLException {
            this._conn.setTransactionIsolation(level);
        }

        public int getTransactionIsolation() throws SQLException {
            return this._conn.getTransactionIsolation();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this._conn.getWarnings();
        }

        public void clearWarnings() throws SQLException {
            this._conn.clearWarnings();
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this._conn.createStatement(resultSetType, resultSetConcurrency);
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this._conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        public Map getTypeMap() throws SQLException {
            return this._conn.getTypeMap();
        }

        public void setTypeMap(Map map) throws SQLException {
            this._conn.setTypeMap(map);
        }

        public void setHoldability(int holdability) throws SQLException {
            this._conn.setHoldability(holdability);
        }

        public int getHoldability() throws SQLException {
            return this._conn.getHoldability();
        }

        public Savepoint setSavepoint() throws SQLException {
            return this._conn.setSavepoint();
        }

        public Savepoint setSavepoint(String name) throws SQLException {
            return this._conn.setSavepoint(name);
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this._conn.rollback(savepoint);
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this._conn.releaseSavepoint(savepoint);
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this._conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        public PreparedStatement prepareStatement(String sql, int autoGenerateKeys) throws SQLException {
            return this._conn.prepareStatement(sql, autoGenerateKeys);
        }

        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this._conn.prepareStatement(sql, columnIndexes);
        }

        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this._conn.prepareStatement(sql, columnNames);
        }
    }
}

