/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WarmerStats
implements JsonpSerializable {
    private final long current;
    private final long total;
    @Nullable
    private final Time totalTime;
    private final long totalTimeInMillis;
    public static final JsonpDeserializer<WarmerStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WarmerStats::setupWarmerStatsDeserializer);

    private WarmerStats(Builder builder) {
        this.current = ApiTypeHelper.requireNonNull(builder.current, this, "current");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, this, "totalTimeInMillis");
    }

    public static WarmerStats of(Function<Builder, ObjectBuilder<WarmerStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long current() {
        return this.current;
    }

    public final long total() {
        return this.total;
    }

    @Nullable
    public final Time totalTime() {
        return this.totalTime;
    }

    public final long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current");
        generator.write(this.current);
        generator.writeKey("total");
        generator.write(this.total);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            this.totalTime.serialize(generator, mapper);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupWarmerStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::totalTime, Time._DESERIALIZER, "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WarmerStats> {
        private Long current;
        private Long total;
        @Nullable
        private Time totalTime;
        private Long totalTimeInMillis;

        public final Builder current(long value) {
            this.current = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder totalTime(@Nullable Time value) {
            this.totalTime = value;
            return this;
        }

        public final Builder totalTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WarmerStats build() {
            this._checkSingleUse();
            return new WarmerStats(this);
        }
    }
}

