/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.List;
import org.fao.geonet.domain.SchematronCriteria;
import org.fao.geonet.domain.SchematronCriteriaEvaluator;
import org.fao.geonet.domain.SchematronCriteriaType;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.locationtech.jts.util.Assert;
import org.springframework.context.ApplicationContext;

public class XPathCriteriaEvaluator
implements SchematronCriteriaEvaluator {
    static final XPathCriteriaEvaluator INSTANCE = new XPathCriteriaEvaluator();
    private static final String OR = "__OR__";
    private static final String AND = "__AND__";

    public static SchematronCriteria createAndCriteria(Text ... textToMatch) {
        return XPathCriteriaEvaluator.createAndCriteria(XPathCriteriaEvaluator.createXpathFrom(textToMatch));
    }

    public static SchematronCriteria createOrCriteria(Text ... textToMatch) {
        return XPathCriteriaEvaluator.createOrCriteria(XPathCriteriaEvaluator.createXpathFrom(textToMatch));
    }

    public static SchematronCriteria createOrCriteria(String ... xpaths) {
        Assert.isTrue((xpaths != null && xpaths.length > 0 ? 1 : 0) != 0, (String)"There needs to be at least one xpath for an OR expression");
        StringBuilder builder = new StringBuilder();
        for (String xpath : xpaths) {
            if (builder.length() > 0) {
                builder.append(OR);
            }
            builder.append(xpath);
        }
        return XPathCriteriaEvaluator.createSchematronCriteria(builder.toString());
    }

    public static SchematronCriteria createAndCriteria(String ... xpaths) {
        Assert.isTrue((xpaths != null && xpaths.length > 0 ? 1 : 0) != 0, (String)"There needs to be at least one xpath for an AND expression");
        StringBuilder builder = new StringBuilder();
        for (String xpath : xpaths) {
            if (builder.length() > 0) {
                builder.append(AND);
            }
            builder.append(xpath);
        }
        return XPathCriteriaEvaluator.createSchematronCriteria(builder.toString());
    }

    private static SchematronCriteria createSchematronCriteria(String value) {
        SchematronCriteria schematronCriteria = new SchematronCriteria();
        schematronCriteria.setType(SchematronCriteriaType.XPATH);
        schematronCriteria.setValue(value);
        return schematronCriteria;
    }

    private static String[] createXpathFrom(Text[] textToMatch) {
        String[] xpaths = new String[textToMatch.length];
        for (int i = 0; i < textToMatch.length; ++i) {
            Text text = textToMatch[i];
            xpaths[i] = Xml.getXPathExpr((Content)text);
        }
        return xpaths;
    }

    @Override
    public boolean accepts(ApplicationContext applicationContext, String value, int metadataId, Element metadata, List<Namespace> metadataNamespaces) {
        String[] ors = value.split(OR);
        boolean orAccepts = false;
        for (String or : ors) {
            String and;
            String[] ands = or.split(AND);
            boolean andAccepts = true;
            String[] stringArray = ands;
            int n = stringArray.length;
            for (int i = 0; i < n && (andAccepts = this.doAccept(and = stringArray[i], metadata, metadataNamespaces)); ++i) {
            }
            orAccepts = andAccepts;
            if (orAccepts) break;
        }
        return orAccepts;
    }

    @Override
    public boolean accepts(ApplicationContext applicationContext, String value, Element metadata, List<Namespace> metadataNamespaces, Integer groupOwnerId) {
        return this.accepts(applicationContext, value, -1, metadata, metadataNamespaces);
    }

    private boolean doAccept(String rawValue, Element metadata, List<Namespace> metadataNamespaces) {
        try {
            List nodes;
            boolean accept;
            Object value = rawValue;
            if (((String)value).startsWith("/") && !((String)value).startsWith("//")) {
                value = ((String)value).substring(1);
            }
            if (((String)value).startsWith(metadata.getQualifiedName() + "/")) {
                value = ((String)value).substring(metadata.getQualifiedName().length() + 1);
            }
            if (((String)value).startsWith("//")) {
                value = "*" + (String)value;
            }
            if (!(accept = this.evaluateResult(nodes = Xml.selectNodes((Element)metadata, (String)value, metadataNamespaces))) && ((String)value).startsWith("*//" + metadata.getQualifiedName())) {
                nodes = Xml.selectNodes((Element)metadata, (String)((String)value).substring(metadata.getQualifiedName().length() + 3), metadataNamespaces);
                accept = this.evaluateResult(nodes);
            }
            if (!accept && rawValue.startsWith("//")) {
                nodes = Xml.selectNodes((Element)metadata, (String)rawValue.substring(2), metadataNamespaces);
                accept = this.evaluateResult(nodes);
            }
            return accept;
        }
        catch (Throwable e) {
            this.warn(rawValue, e);
            return false;
        }
    }

    private boolean evaluateResult(List<?> nodes) {
        boolean accept = false;
        if (nodes.isEmpty()) {
            accept = false;
        } else if (nodes.size() == 1 && nodes.get(0) instanceof Boolean) {
            accept = (Boolean)nodes.get(0);
        } else {
            for (Object node : nodes) {
                if (node instanceof Boolean) {
                    accept = (Boolean)nodes.get(0);
                    if (!accept) continue;
                    break;
                }
                if (node instanceof Text) {
                    Text text = (Text)node;
                    if (text.getTextTrim().isEmpty()) continue;
                    accept = true;
                    break;
                }
                if (!(node instanceof Element) && !(node instanceof Attribute)) continue;
                accept = true;
                break;
            }
        }
        return accept;
    }

    protected void warn(String value, Throwable e) {
        Log.warning((String)"geonetwork.domain", (Object)("Error occurred while evaluating XPATH during schematron evaluation: \n\t" + value), (Throwable)e);
    }
}

